/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.keyboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.hivetechnology.keyboard.Application;

public class DialogKeyBoard
extends JDialog {
    private boolean shift = false;
    private boolean lock = true;
    private boolean alfanumeric;
    private JTextArea jtfOutput;
    private String initialValue;
    private String finalValue;
    private Timer timer;
    private boolean firstDigit = true;
    private boolean touchEnabled = true;

    public DialogKeyBoard(Frame parent, String valoreiniziale, boolean modal, boolean alfa, boolean enterVisibile) {
        super(parent, modal);
        this.Constructor(valoreiniziale, alfa, enterVisibile);
    }

    public DialogKeyBoard(Dialog parent, String initialValue, boolean modal, boolean alfanumeric, boolean enterVisibile) {
        super(parent, modal);
        this.Constructor(initialValue, alfanumeric, enterVisibile);
    }

    private void Constructor(String initialValue, boolean alfanumeric, boolean enterVisibile) {
        this.alfanumeric = alfanumeric;
        this.initialValue = initialValue;
        this.finalValue = initialValue;
        this.initForm(enterVisibile);
        this.startTimerTimeout();
    }

    public void setTouchEnabled(boolean touchEnabled) {
        this.touchEnabled = touchEnabled;
        this.jtfOutput.setEditable(!touchEnabled);
    }

    public void cleatText() {
        this.jtfOutput.setText("");
    }

    public void setDeleteOldText(boolean deleteOldText) {
        this.firstDigit = !deleteOldText;
    }

    public String getValue() {
        return this.finalValue;
    }

    private void esciPerTimeOUT() {
        this.endForm();
    }

    private void startTimerTimeout() {
        this.timer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                DialogKeyBoard.this.esciPerTimeOUT();
            }
        };
        this.timer.schedule(task, 10000L);
    }

    public void disableTimer() {
        this.timer.cancel();
    }

    private void restartTimerTimeout() {
        this.timer.cancel();
        this.startTimerTimeout();
    }

    private void jButtonClicked(ActionEvent evt) {
        this.restartTimerTimeout();
        JButton button = (JButton)evt.getSource();
        String apString = button.getText();
        String apStringOut = "";
        if (this.firstDigit) {
            apStringOut = this.jtfOutput.getText();
        }
        this.firstDigit = true;
        if (!this.alfanumeric) {
            if (apStringOut.length() < 17) {
                if (apString.equals("-")) {
                    if (apStringOut.contains("-")) {
                        apStringOut = apStringOut.replace("-", "");
                        apString = "";
                    } else {
                        apStringOut = "-" + apStringOut;
                        apString = "";
                    }
                }
                if (apString.equals(".") && apStringOut.contains(".")) {
                    apString = "";
                }
                this.jtfOutput.setText(apStringOut + apString);
            }
        } else {
            if (apString.equals("")) {
                apString = "\n";
            }
            this.jtfOutput.setText(apStringOut + apString);
        }
        if (this.shift) {
            this.shift = !this.shift;
            this.cambiaTasti(this);
        }
    }

    private void jButtonExeClicked(ActionEvent evt, String codeexe) {
        this.restartTimerTimeout();
        switch (codeexe) {
            case "shift": {
                this.shift = !this.shift;
                this.cambiaTasti(this);
                break;
            }
            case "lock": {
                this.lock = !this.lock;
                this.cambiaTasti(this);
                break;
            }
            case "space": {
                this.jtfOutput.setText(this.jtfOutput.getText() + " ");
                break;
            }
            case "back": {
                String apString = this.jtfOutput.getText();
                if (apString.isEmpty()) break;
                this.jtfOutput.setText(apString.substring(0, apString.length() - 1));
                break;
            }
            case "clr": {
                this.jtfOutput.setText("");
                break;
            }
            case "esc": {
                this.endForm();
                break;
            }
            case "ok": {
                this.finalValue = this.jtfOutput.getText();
                this.endForm();
                break;
            }
        }
    }

    private void cambiaTasti(Container container) {
        for (Component c : container.getComponents()) {
            if (c instanceof JButton) {
                String apString = ((JButton)c).getText();
                char apCharCode = apString.length() == 1 ? apString.charAt(0) : (char)'\u0000';
                if (apString.contains("Shift")) {
                    apString = this.shift ? "Shift ON" : "Shift OFF";
                } else if (apString.contains("Lock")) {
                    apString = this.lock ? "Lock ON" : "Lock OFF";
                } else if (apCharCode >= 'A' && apCharCode <= 'Z') {
                    if (!(this.lock & !this.shift || !this.lock && this.shift)) {
                        apString = String.valueOf((char)(apCharCode + 32));
                    }
                } else if (apCharCode >= 'a' && apCharCode <= 'z') {
                    if (this.lock & !this.shift || !this.lock && this.shift) {
                        apString = String.valueOf((char)(apCharCode - 32));
                    }
                } else if (apCharCode >= '0' && apCharCode <= '9') {
                    if (this.shift) {
                        switch (apCharCode) {
                            case '0': {
                                apString = "\u20ac";
                                break;
                            }
                            case '2': {
                                apString = "_";
                                break;
                            }
                            default: {
                                apString = String.valueOf((char)(apCharCode - 16));
                                break;
                            }
                        }
                    }
                } else if (apCharCode >= '!' && apCharCode <= ')') {
                    if (!this.shift) {
                        apString = String.valueOf((char)(apCharCode + 16));
                    }
                } else if (apString.equals("\u20ac")) {
                    if (!this.shift) {
                        apString = "0";
                    }
                } else if (apString.equals("_") && !this.shift) {
                    apString = "2";
                }
                ((JButton)c).setText(apString);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.cambiaTasti((Container)c);
        }
    }

    private void endForm() {
        this.timer.cancel();
        this.dispose();
    }

    private void initForm(boolean enterVisibile) {
        int i;
        Box group = Box.createHorizontalBox();
        JPanel jptastnum = new JPanel(new GridLayout(4, 3));
        JButton[] jbtastnum = new JButton[12];
        for (i = 0; i < 9; ++i) {
            jbtastnum[i] = new JButton(Integer.toString(i + 1));
        }
        i = 9;
        jbtastnum[i] = new JButton(".");
        i = 10;
        jbtastnum[i] = new JButton("0");
        i = 11;
        jbtastnum[i] = new JButton("-");
        for (i = 0; i < 12; ++i) {
            jbtastnum[i].addActionListener(evt -> this.jButtonClicked(evt));
            jbtastnum[i].setPreferredSize(new Dimension(50, 50));
            jbtastnum[i].setFont(new Font("Tahoma", 0, 18));
            jptastnum.add(jbtastnum[i]);
        }
        if (this.alfanumeric) {
            JPanel jptastalfa = new JPanel(new GridLayout(4, 7));
            JButton[] jbtastalfa = new JButton[28];
            for (i = 0; i < 26; ++i) {
                jbtastalfa[i] = new JButton(String.valueOf((char)(65 + i)));
            }
            i = 26;
            jbtastalfa[i] = new JButton("@");
            i = 27;
            jbtastalfa[i] = new JButton(new ImageIcon(this.getClass().getResource("/img/enter.png")));
            int ie = enterVisibile ? 28 : 27;
            for (i = 0; i < ie; ++i) {
                jbtastalfa[i].addActionListener(evt -> this.jButtonClicked(evt));
                jbtastalfa[i].setPreferredSize(new Dimension(50, 50));
                jbtastalfa[i].setFont(new Font("Tahoma", 0, 18));
                jptastalfa.add(jbtastalfa[i]);
            }
            JPanel jptastalfaspecial = new JPanel(new FlowLayout(1));
            JButton[] jbtastalfaspecial = new JButton[3];
            String[] codeexe = new String[3];
            i = 0;
            codeexe[0] = "lock";
            jbtastalfaspecial[i] = new JButton("Lock ON");
            jbtastalfaspecial[i].setPreferredSize(new Dimension(90, 50));
            i = 1;
            codeexe[1] = "space";
            jbtastalfaspecial[i] = new JButton();
            jbtastalfaspecial[i].setPreferredSize(new Dimension(150, 50));
            i = 2;
            codeexe[2] = "shift";
            jbtastalfaspecial[i] = new JButton("Shift OFF");
            jbtastalfaspecial[i].setPreferredSize(new Dimension(90, 50));
            for (i = 0; i < 3; ++i) {
                String fcodeexe = codeexe[i];
                jbtastalfaspecial[i].addActionListener(evt -> this.jButtonExeClicked(evt, fcodeexe));
                jbtastalfaspecial[i].setFont(new Font("Tahoma", 0, 14));
                jptastalfaspecial.add(jbtastalfaspecial[i]);
            }
            Box jptastalfapiuspecial = Box.createVerticalBox();
            jptastalfapiuspecial.add(jptastalfa);
            jptastalfapiuspecial.add(jptastalfaspecial);
            group.add(jptastalfapiuspecial);
        }
        JPanel jptastexe = new JPanel(new GridLayout(4, 1));
        JButton[] jbtastexe = new JButton[4];
        String[] codeexe = new String[4];
        i = 0;
        codeexe[i] = "esc";
        jbtastexe[i] = new JButton("ESC");
        jbtastexe[i].setBackground(new Color(192, 192, 255));
        i = 1;
        codeexe[1] = "clr";
        jbtastexe[i] = new JButton("CLR");
        i = 2;
        codeexe[i] = "back";
        jbtastexe[i] = new JButton(new ImageIcon(this.getClass().getResource("/img/back.png")));
        i = 3;
        codeexe[i] = "ok";
        jbtastexe[i] = new JButton("OK");
        jbtastexe[i].setBackground(new Color(255, 192, 192));
        for (i = 0; i < 4; ++i) {
            String fcodeexe = codeexe[i];
            jbtastexe[i].addActionListener(evt -> this.jButtonExeClicked(evt, fcodeexe));
            jbtastexe[i].setFont(new Font("Tahoma", 0, 18));
            jptastexe.add(jbtastexe[i]);
        }
        group.add(jptastnum);
        group.add(jptastexe);
        JPanel container = new JPanel(new FlowLayout(0));
        container.add(group);
        BoxLayout layout = new BoxLayout(this.getContentPane(), 1);
        this.getContentPane().setLayout(layout);
        this.jtfOutput = new JTextArea();
        this.jtfOutput.setText(this.initialValue);
        this.jtfOutput.setEditable(!this.touchEnabled);
        this.jtfOutput.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.jtfOutput.setFont(new Font("Tahoma", 0, 20));
        if (this.alfanumeric) {
            this.jtfOutput.setRows(5);
            this.jtfOutput.setColumns(30);
            this.jtfOutput.setLineWrap(true);
            this.jtfOutput.setWrapStyleWord(true);
            JScrollPane jspOutPut = new JScrollPane(this.jtfOutput);
            this.getContentPane().add(jspOutPut);
        } else {
            this.jtfOutput.setRows(1);
            this.jtfOutput.setColumns(10);
            this.getContentPane().add(this.jtfOutput);
        }
        this.getContentPane().add(container);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogKeyBoard.this.endForm();
            }
        });
        this.setTitle("Keyboard V" + Application.VERSION);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/keyboard-space.png")).getImage());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }
}

