/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.variables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.variables.Variable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Variables<T extends Variable> {
    private static final Logger LOG = LogManager.getLogger();
    private final ArrayList<T> variables = new ArrayList();

    public Variables() {
    }

    public Variables(ArrayList<T> variables) {
        this();
        this.variables.addAll(variables);
    }

    public Variables(Variables<T> variables) {
        this();
        this.variables.addAll(variables.variables);
    }

    public void addVariable(T variable) {
        this.variables.add(variable);
    }

    public void addVariables(ArrayList<T> variables) {
        this.variables.addAll(variables);
    }

    public void addVariables(Variables<T> variables) {
        this.variables.addAll(variables.variables);
    }

    public void addVariables(T[] variables) {
        this.variables.addAll(Arrays.asList(variables));
    }

    public int getSize() {
        return this.variables.size();
    }

    public T getVariable(int id) {
        return (T)((Variable)this.variables.get(id));
    }

    public T getVariable(String name) throws Exception {
        for (Variable variable : this.variables) {
            if (!variable.getName().equals(name)) continue;
            return (T)variable;
        }
        throw new Exception("Variable not found");
    }

    public T getVariableUnsafe(String name) {
        try {
            return this.getVariable(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getValue(int id) {
        return ((Variable)this.getVariable(id)).getValue();
    }

    public String getValue(String name) throws Exception {
        return ((Variable)this.getVariable(name)).getValue();
    }

    public String getValueUnsafe(String name) {
        try {
            return this.getValue(name);
        }
        catch (Exception e) {
            return "";
        }
    }

    public boolean setValues(String[] variablesName, String[] variablesValue) throws Exception {
        boolean rst = false;
        ArrayList<T> vars = this.getVariables(variablesName);
        for (int i = 0; i < variablesName.length; ++i) {
            ((Variable)vars.get(i)).setValue(variablesValue[i]);
        }
        rst = true;
        return rst;
    }

    public boolean setValuesUnsafe(String[] variablesName, String[] variablesValue) {
        try {
            return this.setValues(variablesName, variablesValue);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setValue(String name, String value) throws Exception {
        boolean rst = false;
        T variabile = this.getVariable(name);
        if (!((Variable)variabile).getName().equals("")) {
            ((Variable)variabile).setValue(value);
            rst = true;
        }
        return rst;
    }

    public Iterator<T> getIterator() {
        return this.variables.iterator();
    }

    public String[] getNames() {
        String[] ret = new String[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            ret[i] = ((Variable)this.variables.get(i)).getName();
        }
        return ret;
    }

    public ArrayList<T> getVariables() {
        return this.variables;
    }

    public ArrayList<T> getVariables(String[] variablesName) throws Exception {
        ArrayList<T> rst = new ArrayList<T>();
        for (String variableName : variablesName) {
            T variable = this.getVariable(variableName);
            if (variable == null) continue;
            rst.add(variable);
        }
        return rst;
    }

    public void loadValues(String fileName) {
        File fileSetup = new File(fileName);
        try {
            fileName = fileSetup.getCanonicalPath();
            Iterator<T> variabiliIterator = this.getIterator();
            while (variabiliIterator.hasNext()) {
                Variable current = (Variable)variabiliIterator.next();
                current.setValue(FileUtils.readIniKey((String)fileName, (String)current.getName(), (String)current.getValue()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public boolean saveValues(String fileName) {
        boolean rst = true;
        File fileSetup = new File(fileName);
        try {
            fileName = fileSetup.getCanonicalPath();
            Iterator<T> variabiliIterator = this.getIterator();
            while (variabiliIterator.hasNext()) {
                Variable current = (Variable)variabiliIterator.next();
                FileUtils.writeIniKey((String)fileName, (String)current.getName(), (String)current.getValue());
            }
        }
        catch (Exception e) {
            rst = false;
            LOG.error((Object)e);
        }
        return rst;
    }
}

