/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.variables;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class Variable {
    String name = "";
    private String value = "";
    private String type = "";
    private String mask = "";
    private String lowerBound = "";
    private String upperBound = "";
    private boolean numeric = true;

    public Variable() {
    }

    public Variable(String name) {
        this.name = name;
    }

    public Variable(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static ArrayList<Variable> createVariables(String[] variablesName) {
        ArrayList<Variable> rst = new ArrayList<Variable>();
        for (String name : variablesName) {
            rst.add(new Variable(name));
        }
        return rst;
    }

    public String getFormattedValue() {
        String rst = this.value;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat(this.mask);
        formatter.setDecimalFormatSymbols(decimalFormatSymbols);
        try {
            rst = formatter.format(Double.parseDouble(this.value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rst;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public int getValueInt() {
        int rst = 0;
        try {
            rst = (int)Double.parseDouble(this.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rst;
    }

    public double getValueDouble() {
        double rst = 0.0;
        try {
            rst = Double.parseDouble(this.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rst;
    }

    public boolean getValueBool() {
        return this.value.equals("1") || this.value.equalsIgnoreCase("true");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.value = Integer.toString(value);
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    public void setValue(double value) {
        this.value = Double.toString(value);
    }

    public void setValue(boolean value) {
        this.value = value ? "true" : "false";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(String lowerBound) {
        this.lowerBound = lowerBound;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(String upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }
}

