/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.variables;

import java.util.ArrayList;
import net.hivetechnology.variables.Variable;

public class Timer
extends Variable {
    private int time = 0;
    private long oldTime = 0L;
    private boolean status = false;

    public Timer() {
    }

    public Timer(String name) {
        this.name = name;
    }

    public Timer(int time) {
        this.time = time;
    }

    public void tON(boolean active) {
        if (!active) {
            this.status = false;
            this.setValue(false);
        } else if (!this.status) {
            this.status = true;
            this.oldTime = System.currentTimeMillis();
        } else {
            long newTime = System.currentTimeMillis();
            if (newTime - this.oldTime >= (long)this.time) {
                this.setValue(true);
            }
        }
    }

    public void tON(boolean active, int time) {
        this.setTime(time);
        this.tON(active);
    }

    public void tOFF(boolean active) {
        if (!active) {
            this.status = false;
            this.setValue(false);
        } else if (!this.status) {
            this.status = true;
            this.oldTime = System.currentTimeMillis();
            this.setValue(true);
        } else {
            long newTime = System.currentTimeMillis();
            if (newTime - this.oldTime >= (long)this.time) {
                this.setValue(false);
            }
        }
    }

    public void tOFF(boolean active, int time) {
        this.setTime(time);
        this.tOFF(active);
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public long getElapsedTime() {
        if (this.status) {
            return System.currentTimeMillis() - this.oldTime;
        }
        return 0L;
    }

    public long getRemainingTime() {
        if (this.status) {
            return (long)this.time - this.getElapsedTime();
        }
        return this.time;
    }

    public static ArrayList<Timer> createTimers(String[] variablesName) {
        ArrayList<Timer> rst = new ArrayList<Timer>();
        for (String name : variablesName) {
            rst.add(new Timer(name));
        }
        return rst;
    }
}

