/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.variables;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import net.hivetechnology.variables.Variable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComVariable
extends Variable {
    private static final Logger LOG = LogManager.getLogger();
    private final String className = this.getClass().getCanonicalName();
    private boolean validRecord = false;
    private String connectionName = "";
    private int connectionId = -1;
    private String address = "";
    private boolean eRead = false;
    private boolean readOk = false;
    private int nRead = 0;
    private boolean eWrite = false;
    private boolean writeOk = false;
    private String valueToWrite = "";
    private String valueRead = "";
    private String[] params = new String[3];

    public ComVariable() {
    }

    public ComVariable(String[] data) {
        try {
            super.setName(data[0]);
            this.connectionName = data[1];
            if (!super.getName().equals("") && !this.connectionName.equals("")) {
                this.address = data[2];
                super.setType(data[3]);
                super.setMask(data[4]);
                super.setLowerBound(data[5]);
                super.setUpperBound(data[6]);
                this.validRecord = true;
            }
            if (data.length > 7 && !data[7].equals("")) {
                this.params[0] = data[7];
            }
            if (data.length > 8 && !data[8].equals("")) {
                this.params[1] = data[8];
            }
            if (data.length > 9 && !data[9].equals("")) {
                this.params[2] = data[9];
            }
        }
        catch (Exception e) {
            LOG.error(e + " --> " + Arrays.toString(data));
        }
    }

    public ComVariable(ComVariable variable) {
        this.validRecord = variable.validRecord;
        this.connectionName = variable.connectionName;
        this.connectionId = variable.connectionId;
        this.address = variable.address;
        this.eRead = variable.eRead;
        this.readOk = variable.readOk;
        this.nRead = variable.nRead;
        this.eWrite = variable.eWrite;
        this.writeOk = variable.writeOk;
        this.valueToWrite = variable.valueToWrite;
        this.valueRead = variable.valueRead;
    }

    public boolean isValidRecord() {
        return this.validRecord;
    }

    public void setValidRecord(boolean validRecord) {
        this.validRecord = validRecord;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean iseRead() {
        return this.eRead;
    }

    public void seteRead(boolean eRead) {
        this.eRead = eRead;
    }

    @Deprecated
    public boolean isReadOk() {
        return this.readOk;
    }

    public boolean isReadOk(int old_nread) {
        return this.nRead > 0 && this.nRead != old_nread;
    }

    public int getnRead() {
        return this.nRead;
    }

    public void incnRead() {
        try {
            ++this.nRead;
        }
        catch (Exception e) {
            this.nRead = 1;
        }
    }

    public String[] getParams() {
        return this.params;
    }

    @Deprecated
    public void setReadOk(boolean readOk) {
        this.readOk = readOk;
    }

    public boolean iseWrite() {
        return this.eWrite;
    }

    public void seteWrite(boolean eWrite) {
        this.eWrite = eWrite;
    }

    public boolean isWriteOk() {
        return this.writeOk;
    }

    public void setWriteOk(boolean writeOk) {
        this.writeOk = writeOk;
    }

    public String getValueToWrite() {
        return this.valueToWrite;
    }

    public void setValueToWrite(String valueToWrite) {
        this.valueToWrite = valueToWrite;
    }

    public String getValueRead() {
        return this.valueRead;
    }

    public void setValueRead(String valueRead) {
        this.valueRead = valueRead;
        this.setValue(valueRead);
    }

    @Override
    public String getFormattedValue() {
        String rst;
        if (this.isValidRecord()) {
            if (this.getType().toUpperCase().equals("STRING")) {
                rst = this.getValueRead();
            } else {
                String dato;
                Double Q;
                Double K;
                String maschera;
                int posizioneK = this.getMask().indexOf("K");
                int posizioneQ = this.getMask().indexOf("Q");
                if (posizioneK > 0) {
                    maschera = this.getMask().substring(0, posizioneK);
                    if (posizioneQ > 0) {
                        K = Double.parseDouble(this.getMask().substring(posizioneK + 1, posizioneQ));
                        Q = Double.parseDouble(this.getMask().substring(posizioneQ + 1, this.getMask().length()));
                    } else {
                        K = Double.parseDouble(this.getMask().substring(posizioneK + 1, this.getMask().length()));
                        Q = 0.0;
                    }
                } else if (posizioneQ > 0) {
                    maschera = this.getMask().substring(0, posizioneQ);
                    K = 1.0;
                    Q = Double.parseDouble(this.getMask().substring(posizioneQ + 1, this.getMask().length()));
                } else {
                    maschera = this.getMask();
                    K = 1.0;
                    Q = 0.0;
                }
                try {
                    dato = Double.toString(Double.parseDouble(this.getValueRead()) / K - Q);
                }
                catch (NumberFormatException e) {
                    dato = this.getValueRead();
                }
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                decimalFormatSymbols.setGroupingSeparator('\'');
                decimalFormatSymbols.setDecimalSeparator('.');
                DecimalFormat formatter = new DecimalFormat(maschera);
                formatter.setDecimalFormatSymbols(decimalFormatSymbols);
                formatter.setGroupingUsed(false);
                if (this.getType().toUpperCase().equals("INT") || this.getType().toUpperCase().equals("DINT")) {
                    int posizioneVirgola = maschera.lastIndexOf(".");
                    if (posizioneVirgola > 0) {
                        posizioneVirgola = maschera.length() - posizioneVirgola - 1;
                    }
                    if (posizioneVirgola < 0) {
                        posizioneVirgola = 0;
                    }
                    try {
                        rst = formatter.format(Double.parseDouble(dato) / Math.pow(10.0, posizioneVirgola));
                    }
                    catch (Exception e) {
                        rst = "####";
                    }
                } else {
                    try {
                        rst = formatter.format(dato);
                    }
                    catch (Exception e) {
                        rst = dato;
                    }
                }
            }
        } else {
            rst = "####";
        }
        return rst;
    }

    public void setFormattedValue(String value) {
        String rst = "####";
        if (this.isValidRecord()) {
            String dato;
            int Q;
            int K;
            String maschera;
            int posizioneK = this.getMask().indexOf("K");
            int posizioneQ = this.getMask().indexOf("Q");
            if (posizioneK > 0) {
                maschera = this.getMask().substring(0, posizioneK);
                if (posizioneQ > 0) {
                    K = Integer.parseInt(this.getMask().substring(posizioneK + 1, posizioneQ));
                    Q = Integer.parseInt(this.getMask().substring(posizioneQ + 1, this.getMask().length()));
                } else {
                    K = Integer.parseInt(this.getMask().substring(posizioneK + 1, this.getMask().length()));
                    Q = 0;
                }
            } else if (posizioneQ > 0) {
                maschera = this.getMask().substring(0, posizioneQ);
                K = 1;
                Q = Integer.parseInt(this.getMask().substring(posizioneQ + 1, this.getMask().length()));
            } else {
                maschera = this.getMask();
                K = 1;
                Q = 0;
            }
            try {
                dato = Double.toString(Double.parseDouble(value) * (double)K + (double)Q);
            }
            catch (NumberFormatException e) {
                dato = this.getValueRead();
            }
            if (this.getType().toUpperCase().equals("INT") || this.getType().toUpperCase().equals("DINT")) {
                int posizioneVirgola = maschera.lastIndexOf(".");
                if (posizioneVirgola > 0) {
                    posizioneVirgola = maschera.length() - posizioneVirgola - 1;
                }
                if (posizioneVirgola < 0) {
                    posizioneVirgola = 0;
                }
                try {
                    int valueInt = (int)(Double.parseDouble(dato) * Math.pow(10.0, posizioneVirgola));
                    rst = Integer.toString(valueInt);
                }
                catch (Exception valueInt) {}
            } else {
                try {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                    decimalFormatSymbols.setGroupingSeparator('\'');
                    decimalFormatSymbols.setDecimalSeparator('.');
                    DecimalFormat formatter = new DecimalFormat(maschera);
                    formatter.setDecimalFormatSymbols(decimalFormatSymbols);
                    rst = formatter.format(Double.parseDouble(dato));
                }
                catch (Exception e) {
                    rst = dato;
                }
            }
        }
        this.setValue(rst);
    }
}

