/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.modbus;

import com.serotonin.modbus4j.serial.SerialPortWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import jssc.SerialPort;
import jssc.SerialPortException;

public class SerialPortWrapperImpl_jssc
implements SerialPortWrapper {
    private int baudRate;
    private int flowControlIn;
    private int flowControlOut;
    private int dataBits;
    private int stopBits;
    private int parity;
    private final SerialPort port;

    public SerialPortWrapperImpl_jssc(String portName, int baudRate, int flowControl, int dataBits, int stopBits, int parity) {
        this.baudRate = baudRate;
        this.flowControlIn = flowControl;
        this.flowControlOut = flowControl;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        this.port = new SerialPort(portName);
    }

    @Override
    public void close() throws Exception {
        this.port.closePort();
    }

    @Override
    public void open() throws Exception {
        this.port.openPort();
        this.port.setParams(this.getBaudRate(), this.getDataBits(), this.getStopBits(), this.getParity());
        this.port.setFlowControlMode(this.getFlowControlIn() | this.getFlowControlOut());
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new JSSCInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return new JSSCOutputStream();
    }

    @Override
    public int getBaudRate() {
        return this.baudRate;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    @Override
    public int getStopBits() {
        return this.stopBits;
    }

    @Override
    public int getParity() {
        return this.parity;
    }

    @Override
    public int getFlowControlIn() {
        return this.flowControlIn;
    }

    @Override
    public int getFlowControlOut() {
        return this.flowControlOut;
    }

    public class JSSCOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
            try {
                SerialPortWrapperImpl_jssc.this.port.writeByte((byte)b);
            }
            catch (SerialPortException e) {
                throw new IOException();
            }
        }
    }

    private class JSSCInputStream
    extends InputStream {
        private final PipedInputStream pipeIn = new PipedInputStream();
        private final PipedOutputStream pipeOut = new PipedOutputStream(this.pipeIn);
        byte[] data;

        public JSSCInputStream() throws IOException {
            this.loadPipe();
        }

        private void loadPipe() {
            try {
                int available = SerialPortWrapperImpl_jssc.this.port.getInputBufferBytesCount();
                if (available > 0) {
                    this.data = SerialPortWrapperImpl_jssc.this.port.readBytes();
                    if (this.data != null) {
                        try {
                            this.pipeOut.write(this.data);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (SerialPortException serialPortException) {
                // empty catch block
            }
        }

        @Override
        public int available() throws IOException {
            this.loadPipe();
            return this.pipeIn.available();
        }

        @Override
        public void close() throws IOException {
            this.pipeIn.close();
        }

        @Override
        public void mark(int arg0) {
            this.pipeIn.mark(arg0);
        }

        @Override
        public boolean markSupported() {
            return this.pipeIn.markSupported();
        }

        @Override
        public int read() throws IOException {
            this.loadPipe();
            return this.pipeIn.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.pipeIn.read(b, off, len);
        }

        @Override
        public int read(byte[] arg0) throws IOException {
            return this.pipeIn.read(arg0);
        }

        @Override
        public void reset() throws IOException {
            this.pipeIn.reset();
        }

        @Override
        public long skip(long arg0) throws IOException {
            return this.pipeIn.skip(arg0);
        }

        public String toString() {
            return this.pipeIn.toString();
        }
    }
}

