/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.modbus;

import com.serotonin.modbus4j.serial.SerialPortWrapper;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class SerialPortWrapperImpl_RXTX
implements SerialPortWrapper {
    private int baudRate;
    private int flowControlIn;
    private int flowControlOut;
    private int dataBits;
    private int stopBits;
    private int parity;
    private SerialPort serialPort;
    private CommPortIdentifier portId;
    private InputStream input = null;
    private OutputStream output = null;

    public SerialPortWrapperImpl_RXTX(String portName, int baudRate, int flowControl, int dataBits, int stopBits, int parity) {
        this.baudRate = baudRate;
        this.flowControlIn = flowControl;
        this.flowControlOut = flowControl;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        String defaultPort = portName;
        boolean portFound = false;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            this.portId = (CommPortIdentifier)portList.nextElement();
            if (this.portId.getPortType() != 1 || !this.portId.getName().equals(defaultPort)) continue;
            System.out.println("Found port: " + defaultPort);
            portFound = true;
            break;
        }
        if (!portFound) {
            System.out.println("port " + defaultPort + " not found.");
        }
    }

    @Override
    public void close() throws Exception {
        this.serialPort.close();
        this.input.close();
        this.output.close();
    }

    @Override
    public void open() throws Exception {
        try {
            this.serialPort = (SerialPort)this.portId.open(this.portId.getName(), 500);
            try {
                this.serialPort.setSerialPortParams(this.baudRate, this.dataBits, this.stopBits, this.parity);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            this.input = this.serialPort.getInputStream();
            this.output = this.serialPort.getOutputStream();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.input;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public int getBaudRate() {
        return this.baudRate;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    @Override
    public int getStopBits() {
        return this.stopBits;
    }

    @Override
    public int getParity() {
        return this.parity;
    }

    @Override
    public int getFlowControlIn() {
        return this.flowControlIn;
    }

    @Override
    public int getFlowControlOut() {
        return this.flowControlOut;
    }
}

