/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.hivetechnology.application.AboutScreen;
import net.hivetechnology.application.Application;

public class SplashScreen
extends JFrame {
    final Application appData;
    JLabel jlLoading;
    Timer timer;

    public SplashScreen(Application AppData) {
        this.appData = AppData;
        this.initForm();
        this.initTimer();
    }

    private void initForm() {
        JButton jbAbout = new JButton("?");
        jbAbout.addActionListener(evt -> AboutScreen.getInstance(this.appData).setVisible(true));
        JPanel jpAbout = new JPanel();
        jpAbout.setLayout(new FlowLayout(2));
        jpAbout.setOpaque(false);
        jpAbout.add(jbAbout);
        BackgroundPanel jpBackground = new BackgroundPanel(this.appData.getFAVICON_URL());
        JPanel jpInfo = new JPanel();
        String name = this.appData.getNAME() + " (" + this.appData.getCODE() + ")";
        JTextArea jtaName = new JTextArea(name);
        jtaName.setLineWrap(true);
        jtaName.setWrapStyleWord(true);
        jtaName.setEditable(false);
        jtaName.setForeground(Color.WHITE);
        jtaName.setOpaque(false);
        jtaName.setOpaque(false);
        jtaName.setBorder(null);
        jtaName.setBackground(Color.decode("#222222"));
        this.jlLoading = new JLabel();
        this.jlLoading.setForeground(Color.WHITE);
        jpBackground.setPreferredSize(new Dimension(400, 256));
        this.getContentPane().add((Component)jpBackground, "Center");
        jpBackground.setLayout(new BorderLayout());
        JPanel jpInner = new JPanel();
        jpInner.setLayout(new BorderLayout());
        jpInner.setOpaque(false);
        jpBackground.add((Component)jpAbout, "First");
        jpInner.setBorder(new EmptyBorder(0, 10, 10, 0));
        jpBackground.add((Component)jpInner, "South");
        jpBackground.setBackground(Color.decode("#222222"));
        jtaName.setFont(new Font("Tahoma", 0, 20));
        jpInner.add(jtaName);
        jpInfo.setLayout(new FlowLayout(0));
        jpInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        jpInfo.setBackground(Color.decode("#3f51b5"));
        jpInfo.add(this.jlLoading);
        this.getContentPane().add((Component)jpInfo, "South");
        this.setTitle(name);
        this.setIconImage(this.appData.getFAVICON_IMG());
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void close() {
        this.timer.cancel();
        this.dispose();
    }

    private void initTimer() {
        this.timer = new Timer();
        TimerTask taskMaster = new TimerTask(){
            int contatore = 99;
            String startText = "Loading components";
            String text;

            @Override
            public void run() {
                if (this.contatore++ < 10) {
                    this.text = this.text + ".";
                } else {
                    this.contatore = 0;
                    this.text = this.startText;
                }
                SwingUtilities.invokeLater(() -> SplashScreen.this.jlLoading.setText(this.text));
            }
        };
        this.timer.schedule(taskMaster, 0L, 500L);
    }

    class BackgroundPanel
    extends JPanel {
        private BufferedImage image;

        public BackgroundPanel(URL img) {
            try {
                this.image = ImageIO.read(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            int ratio = imageWidth / imageHeight;
            imageWidth = 155;
            imageHeight = imageWidth / ratio;
            g.drawImage(this.image, (this.getWidth() - imageWidth) / 2, (this.getHeight() - imageHeight) / 2 - 16, imageWidth, imageHeight, null);
        }
    }
}

