/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.application;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class Logs {
    private static final String PATTERN = "%-5p | %d{yyyy-MM-dd HH:mm:ss} | [%t] %C{}.%M (%F:%L) - %m%n";

    public static String initLOG(String logLevel, boolean createLogsFiles, String logsPath) {
        String ret = "";
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        LayoutComponentBuilder standard = builder.newLayout("PatternLayout");
        standard.addAttribute("pattern", PATTERN);
        AppenderComponentBuilder console = builder.newAppender("stdout", "Console");
        console.add(standard);
        builder.add(console);
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(Level.ALL);
        rootLogger.add(builder.newAppenderRef("stdout"));
        if (createLogsFiles) {
            String appLogsPath = logsPath.equals("") ? (ret = "logs") : (ret = logsPath);
            FilterComponentBuilder filterERROR = (FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY).addAttribute("level", Level.ERROR);
            FilterComponentBuilder filterFATAL = (FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY).addAttribute("level", Level.FATAL);
            FilterComponentBuilder filterINFO = (FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY).addAttribute("level", Level.INFO);
            ComponentBuilder triggeringPolicies = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "5M"));
            AppenderComponentBuilder rollingFileERROR = builder.newAppender("ERROR", "RollingFile");
            rollingFileERROR.addAttribute("fileName", appLogsPath + "/error.log");
            rollingFileERROR.addAttribute("filePattern", appLogsPath + "/error/error%i.log.gz");
            rollingFileERROR.add(standard);
            rollingFileERROR.addComponent(triggeringPolicies);
            rollingFileERROR.add(filterERROR);
            builder.add(rollingFileERROR);
            rootLogger.add(builder.newAppenderRef("ERROR"));
            AppenderComponentBuilder rollingFileCOMBINED = builder.newAppender("COMBINED", "RollingFile");
            rollingFileCOMBINED.addAttribute("fileName", appLogsPath + "/combined.log");
            rollingFileCOMBINED.addAttribute("filePattern", appLogsPath + "/combined/combined%i.log.gz");
            rollingFileCOMBINED.add(standard);
            rollingFileCOMBINED.addComponent(triggeringPolicies);
            rollingFileCOMBINED.add(filterINFO);
            builder.add(rollingFileCOMBINED);
            rootLogger.add(builder.newAppenderRef("COMBINED"));
            if (logLevel.equalsIgnoreCase("DEBUG")) {
                AppenderComponentBuilder rollingFileDEBUG = builder.newAppender("DEBUG", "RollingFile");
                rollingFileDEBUG.addAttribute("fileName", appLogsPath + "/debug.log");
                rollingFileDEBUG.addAttribute("filePattern", appLogsPath + "/debug/debug%i.log.gz");
                rollingFileDEBUG.add(standard);
                rollingFileDEBUG.addComponent(triggeringPolicies);
                builder.add(rollingFileDEBUG);
                rootLogger.add(builder.newAppenderRef("DEBUG"));
            }
        }
        builder.add(rootLogger);
        Configurator.initialize((Configuration)((Configuration)builder.build()));
        if (logLevel.equalsIgnoreCase("DEBUG")) {
            Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.DEBUG);
        } else {
            Configurator.setAllLevels((String)LogManager.getRootLogger().getName(), (Level)Level.INFO);
        }
        return ret;
    }
}

