/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.application;

import java.awt.Image;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;

public abstract class Application {
    private Package PACKAGE;
    private String PACKAGE_NAME;
    private String VERSION;
    private final String AUTHOR = "Hive Technology";
    private final String AUTHOR_URL = "https://hivetechnology.net";
    private final String CREDITS = "hivetechnology.net";
    private final String PID;
    private String CODE;
    private String NAME;
    private String DESCRIPTION;
    private String DOCUMENT_LINK;
    private final AtomicBoolean appEND = new AtomicBoolean(false);
    private final AtomicBoolean appRUN = new AtomicBoolean(true);
    private URL FAVICON_URL;
    private Image FAVICON_IMG;
    public String language = "ENG";

    public Application() {
        if (this.PACKAGE == null) {
            this.PACKAGE = this.getClass().getPackage();
            this.PACKAGE_NAME = this.PACKAGE.getName();
            this.VERSION = this.PACKAGE.getImplementationVersion();
        }
        if (this.CODE == null) {
            this.CODE = this.initCODE();
        }
        if (this.NAME == null) {
            this.NAME = this.initNAME();
        }
        if (this.DESCRIPTION == null) {
            this.DESCRIPTION = this.initDESCRIPTION();
        }
        if (this.FAVICON_URL == null) {
            this.FAVICON_URL = this.initFAVICON_URL();
            this.FAVICON_IMG = new ImageIcon(this.FAVICON_URL).getImage();
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.PID = runtimeMXBean.getName();
    }

    public Application(String DOCUMENT_LINK) {
        this();
        this.setDOCUMENT_LINK(DOCUMENT_LINK);
    }

    protected abstract String initCODE();

    protected abstract String initNAME();

    protected abstract String initDESCRIPTION();

    protected abstract URL initFAVICON_URL();

    private void setDOCUMENT_LINK(String DOCUMENT_LINK) {
        if (this.DOCUMENT_LINK == null) {
            this.DOCUMENT_LINK = DOCUMENT_LINK;
        }
    }

    public String getAUTHOR() {
        return "Hive Technology";
    }

    public String getAUTHOR_URL() {
        return "https://hivetechnology.net";
    }

    public String getCREDITS() {
        return "hivetechnology.net";
    }

    public String getPACKAGE_NAME() {
        return this.PACKAGE_NAME;
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public String getCODE() {
        return this.CODE;
    }

    public String getNAME() {
        return this.NAME;
    }

    public String getDESCRIPTION() {
        return this.DESCRIPTION;
    }

    public URL getFAVICON_URL() {
        return this.FAVICON_URL;
    }

    public Image getFAVICON_IMG() {
        return this.FAVICON_IMG;
    }

    public String getDOCUMENT_LINK() {
        return this.DOCUMENT_LINK;
    }

    public String getPID() {
        return this.PID;
    }

    public AtomicBoolean getAppEND() {
        return this.appEND;
    }

    public boolean appEND() {
        return this.appEND.get();
    }

    public void setAppEND(boolean appEND) {
        this.appEND.set(appEND);
    }

    public AtomicBoolean getAppRUN() {
        return this.appRUN;
    }

    public boolean appRUN() {
        return this.appRUN.get();
    }

    public void setAppRUN(boolean appRUN) {
        this.appRUN.set(appRUN);
    }
}

