/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.hivetechnology.application.Application;

public class AboutScreen
extends JFrame {
    private final String className = this.getClass().getCanonicalName();
    final Application appData;
    private static AboutScreen INSTANCE = null;

    public static AboutScreen getInstance(Application AppData) {
        if (INSTANCE == null) {
            INSTANCE = new AboutScreen(AppData);
        }
        return INSTANCE;
    }

    public AboutScreen(Application AppData) {
        this.appData = AppData;
        this.initForm();
    }

    private void initForm() {
        Font f = new Font("Tahoma", 0, 12);
        Map<TextAttribute, ?> attributes = f.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        Font boldFont = f.deriveFont(attributes);
        JButton jbClose = new JButton("X");
        jbClose.addActionListener(evt -> this.close());
        JPanel jpClose = new JPanel();
        jpClose.setLayout(new FlowLayout(2));
        jpClose.setOpaque(false);
        jpClose.add(jbClose);
        BackgroundPanel jpBackground = new BackgroundPanel(this.appData.getFAVICON_URL());
        JPanel jpInfo = new JPanel();
        String name = this.appData.getNAME() + " (" + this.appData.getCODE() + ")";
        JTextArea jtaName = new JTextArea(name);
        jtaName.setLineWrap(true);
        jtaName.setWrapStyleWord(true);
        jtaName.setEditable(false);
        jtaName.setForeground(Color.WHITE);
        jtaName.setOpaque(false);
        jtaName.setBorder(null);
        jtaName.setBackground(Color.decode("#222222"));
        JLabel jlVersion = new JLabel("V" + this.appData.getVERSION());
        jlVersion.setForeground(Color.WHITE);
        JLabel jDes = new JLabel(this.appData.getDESCRIPTION());
        jDes.setForeground(Color.WHITE);
        jpBackground.setPreferredSize(new Dimension(400, 256));
        this.getContentPane().add((Component)jpBackground, "Center");
        jpBackground.setLayout(new BorderLayout());
        JPanel jpInner = new JPanel();
        jpInner.setLayout(new BorderLayout());
        jpInner.setOpaque(false);
        jpInner.setBorder(new EmptyBorder(0, 10, 10, 0));
        jpBackground.add((Component)jpClose, "First");
        jpBackground.add((Component)jpInner, "South");
        jpBackground.setBackground(Color.decode("#222222"));
        jtaName.setFont(new Font("Tahoma", 0, 20));
        jpInner.add(jtaName);
        jpInfo.setLayout(new BoxLayout(jpInfo, 1));
        jpInfo.setBorder(new EmptyBorder(5, 5, 5, 5));
        jpInfo.setBackground(Color.decode("#3f51b5"));
        jpInfo.add(jlVersion);
        jpInfo.add(jDes);
        if (this.appData.getDOCUMENT_LINK() != null) {
            JLabel jlDoc = new JLabel("Documents");
            jlDoc.setForeground(Color.WHITE.darker());
            jlDoc.setFont(boldFont);
            jlDoc.setCursor(Cursor.getPredefinedCursor(12));
            jlDoc.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        try {
                            Desktop.getDesktop().browse(new URI(AboutScreen.this.appData.getDOCUMENT_LINK()));
                        }
                        catch (Exception e) {
                            System.out.println("Error " + AboutScreen.this.className + ".initForm --> " + e);
                        }
                    }
                }
            });
            jpInfo.add(jlDoc);
        }
        JLabel jlCredits = new JLabel(this.appData.getCREDITS());
        jlCredits.setForeground(Color.WHITE.darker());
        jlCredits.setCursor(Cursor.getPredefinedCursor(12));
        jlCredits.setFont(boldFont);
        jlCredits.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://www.hivetechnology.net"));
                    }
                    catch (Exception e) {
                        System.out.println("Error " + AboutScreen.this.className + ".initForm --> " + e);
                    }
                }
            }
        });
        jpInfo.add(jlCredits);
        JLabel jCopy = new JLabel("<html>" + Calendar.getInstance().get(1) + " &copy; " + this.appData.getCREDITS() + "<br></html>");
        jCopy.setForeground(Color.WHITE);
        jpInfo.add(jCopy);
        this.getContentPane().add((Component)jpInfo, "South");
        this.setTitle(name);
        this.setIconImage(this.appData.getFAVICON_IMG());
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void close() {
        this.dispose();
        INSTANCE = null;
    }

    class BackgroundPanel
    extends JPanel {
        private BufferedImage image;

        public BackgroundPanel(URL img) {
            try {
                this.image = ImageIO.read(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int imageWidth = this.image.getWidth();
            int imageHeight = this.image.getHeight();
            int ratio = imageWidth / imageHeight;
            imageWidth = 155;
            imageHeight = imageWidth / ratio;
            g.drawImage(this.image, (this.getWidth() - imageWidth) / 2, (this.getHeight() - imageHeight) / 2 - 16, imageWidth, imageHeight, null);
        }
    }
}

