/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.plc.drive;

import net.hivetechnology.plc.azionamenti.Azionamento;

public class Lexium32 {
    int ControlWord = 0;
    int OperationMode = 3;
    int HomingMetod = 35;
    int TergetVelocity = 0;
    int TargetPosition = 0;
    int ProfileVelocity = 0;
    int PositionHome = 0;
    int StatusWord = 0;

    public Lexium32(Azionamento Az, int ModoAUTO, int SpeedDes, int PosDes, int PosHome, boolean ResetAlarm, int StatusWord, int ActiveOpMode) {
        this.StatusWord = StatusWord;
        this.ControlWord = Az.getCondizioni_Generali() && ModoAUTO != 4 ? 15 : 6;
        if (ResetAlarm) {
            this.ControlWord |= 0x80;
        }
        if (Az.getAUTO() || Az.getAVANTI() || !Az.getINDIETRO()) {
            // empty if block
        }
        if (Az.getAVANTI() || Az.getINDIETRO() || Az.getAUTO() && ModoAUTO == 1) {
            this.OperationMode = 3;
        } else if (Az.getAUTO() && (ModoAUTO == 2 || ModoAUTO == 3)) {
            this.OperationMode = 1;
        } else if (Az.getAUTO() && ModoAUTO == 4) {
            this.OperationMode = 6;
        }
        if (!Az.getAUTO() && !Az.getAVANTI() && !Az.getINDIETRO() || this.OperationMode != ActiveOpMode) {
            this.TergetVelocity = 0;
            this.ControlWord &= 0x7F8F;
        } else if (Az.getAUTO()) {
            switch (ModoAUTO) {
                case 1: {
                    this.TergetVelocity = SpeedDes;
                    break;
                }
                case 2: {
                    this.TergetVelocity = 0;
                    this.ControlWord |= 0x50;
                    break;
                }
                case 3: {
                    this.TergetVelocity = 0;
                    this.ControlWord |= 0x10;
                    break;
                }
                case 4: {
                    this.TergetVelocity = 0;
                    this.ControlWord |= 0x10;
                    break;
                }
            }
        } else if (Az.getAVANTI()) {
            this.TergetVelocity = SpeedDes;
        } else if (Az.getINDIETRO()) {
            this.TergetVelocity = SpeedDes * -1;
        }
        this.ProfileVelocity = SpeedDes;
        this.TargetPosition = PosDes;
        this.PositionHome = PosHome;
    }

    public int getOperationMode() {
        return this.OperationMode;
    }

    public int getControlWord() {
        return this.ControlWord;
    }

    public int getTergetVelocity() {
        return this.TergetVelocity;
    }

    public int getTargetPosition() {
        return this.TargetPosition;
    }

    public int getHomingMetod() {
        return this.HomingMetod;
    }

    public int getProfileVelocity() {
        return this.ProfileVelocity;
    }

    public int getPositionHome() {
        return this.PositionHome;
    }

    public boolean getReadyToSwitchOn() {
        return (this.StatusWord & 1) > 0;
    }

    public boolean getSwitchOn() {
        return (this.StatusWord & 2) > 0;
    }

    public boolean getFault() {
        return (this.StatusWord & 8) > 0;
    }

    public boolean getSwitchOnDisabled() {
        return (this.StatusWord & 0x40) > 0;
    }
}

