/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.plc.comunication;

import com.serotonin.modbus4j.ModbusFactory;
import com.serotonin.modbus4j.ModbusMaster;
import com.serotonin.modbus4j.ip.IpParameters;
import com.serotonin.modbus4j.msg.ModbusRequest;
import com.serotonin.modbus4j.msg.ReadHoldingRegistersRequest;
import com.serotonin.modbus4j.msg.ReadHoldingRegistersResponse;
import com.serotonin.modbus4j.msg.WriteRegistersRequest;
import com.serotonin.modbus4j.msg.WriteRegistersResponse;
import com.serotonin.modbus4j.serial.SerialPortWrapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilderFactory;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import net.hivetechnology.modbus.SerialPortWrapperImpl_jssc;
import net.hivetechnology.plc.Application;
import net.hivetechnology.plc.comunication.Connection;
import net.hivetechnology.variables.ComVariable;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;

public class Comunication {
    private static final Logger LOG = LogManager.getLogger();
    private String NAME = "PLC";
    private boolean connectionFileOk = false;
    private boolean variablesFileOk = false;
    private String dir;
    private final ArrayList<Connection> connections = new ArrayList();
    private final ArrayList<ComVariable> variables = new ArrayList();
    private boolean extRUN = false;
    private boolean runningFileRow = false;
    private boolean runningFileCol = false;
    private boolean runningModbusRTU = false;
    private boolean runningModbusTCPIP = false;
    private boolean runningSavio = false;
    private boolean runningAPI = false;
    private int IndiceVariabileSchedulazioneFileTestoRow = 0;
    private int IndiceVariabileSchedulazioneFileTestoCol = 0;
    private int IndiceVariabileSchedulazioneModbusRTU = 0;
    private int IndiceVariabileSchedulazioneModbusTCPIP = 0;
    private int IndiceVariabileSchedulazioneSavio = 0;
    private int IndiceVariabileSchedulazioneAPI = 0;
    private boolean schedulingCondition = false;
    private ModbusMaster ModbusMaster;
    private ModbusMaster ModbusMasterTCPIP;
    int timerInterval = 10;
    public static final int DRIVER_FILE_ROW = 2;
    public static final int DRIVER_MODBUS_RTU = 3;
    public static final int DRIVER_FILE_COLUMN = 4;
    public static final int DRIVER_SAVIO = 5;
    public static final int DRIVER_MODBUS_TCPIP = 7;
    public static final int DRIVER_API = 8;

    public Comunication(String dir) {
        this.NAME = this.NAME + " " + this.getClass().getCanonicalName();
        LOG.info(this.NAME + " V" + Application.VERSION);
        if (dir.equals("")) {
            LOG.error("Main folder not set");
        } else {
            this.dir = dir;
            File file = new File(this.dir + File.separatorChar + "connections.csv");
            if (file.exists()) {
                this.connectionFileOk = true;
            } else {
                LOG.error("File: " + file.getPath() + " not found");
            }
            file = new File(this.dir + File.separatorChar + "tags.csv");
            if (file.exists()) {
                this.variablesFileOk = true;
            } else {
                LOG.error("File: " + file.getPath() + " not found");
            }
        }
        this.initData();
    }

    private void initData() {
        if (this.areDefinitionFilesOk()) {
            boolean atLeastOneConnection = this.getConnections();
            boolean atLeastOneVariable = this.getVariables();
            this.schedulingCondition = atLeastOneConnection && atLeastOneVariable;
        }
    }

    private boolean schedulingConditions(int driver) {
        ComVariable variable;
        Connection connection = this.connections.stream().filter(o -> o.getDriver() == driver).findAny().orElse(null);
        return connection != null && (variable = (ComVariable)this.variables.stream().filter(o -> o.getConnectionName().equals(connection.getName())).findAny().orElse(null)) != null;
    }

    public boolean areDefinitionFilesOk() {
        return this.connectionFileOk && this.variablesFileOk;
    }

    public boolean getConnections() {
        boolean rst = false;
        if (this.connectionFileOk) {
            File file = new File(this.dir + File.separatorChar + "connections.csv");
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] row = line.split(",", -1);
                    this.connections.add(new Connection(row));
                }
                rst = true;
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return rst;
    }

    public ArrayList<ComVariable> getAllVariables() {
        return this.variables;
    }

    public boolean getVariables() {
        boolean rst = false;
        if (this.variablesFileOk) {
            File file = new File(this.dir + File.separatorChar + "tags.csv");
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = br.readLine()) != null) {
                    int i;
                    String[] row = line.split(",", -1);
                    ComVariable variable = new ComVariable(row);
                    if (variable.isValidRecord()) {
                        for (i = 0; i < this.connections.size(); ++i) {
                            if (!this.connections.get(i).isValidRecord() || !this.connections.get(i).getName().equals(variable.getConnectionName())) continue;
                            variable.setConnectionId(i);
                            break;
                        }
                        if (variable.getConnectionId() == -1) {
                            variable.setValidRecord(false);
                            LOG.info(variable.getName() + " id connection problem");
                        }
                    }
                    if (variable.isValidRecord()) {
                        for (i = 0; i < this.variables.size(); ++i) {
                            if (!this.variables.get(i).isValidRecord() || !this.variables.get(i).getName().equals(variable.getName())) continue;
                            variable.setValidRecord(false);
                            LOG.info(variable.getName() + " variable not unique");
                            break;
                        }
                    }
                    if (variable.isValidRecord()) {
                        int apCollegamentoDriver = this.connections.get(variable.getConnectionId()).getDriver();
                        switch (apCollegamentoDriver) {
                            case 1: {
                                variable.setValidRecord(false);
                                break;
                            }
                            case 2: 
                            case 4: {
                                variable.setValidRecord(this.checkFileVariablesCoherence(variable));
                                break;
                            }
                            case 3: 
                            case 7: {
                                variable.setValidRecord(this.checkModbusVariablesCoherence(variable));
                                break;
                            }
                            case 5: {
                                variable.setValidRecord(this.checkSavioVariablesCoherence(variable));
                                break;
                            }
                            case 8: {
                                variable.setValidRecord(this.checkAPIVariablesCoherence(variable));
                                break;
                            }
                            default: {
                                variable.setValidRecord(false);
                                LOG.info(variable.getName() + " data consistency error");
                            }
                        }
                    }
                    this.variables.add(variable);
                }
                this.removeInvalidVariables();
                rst = this.variables.size() > 0;
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return rst;
    }

    public void refreshVariablesMask() {
        if (this.variablesFileOk) {
            File file = new File(this.dir + File.separatorChar + "tags.csv");
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String line;
                int i = 0;
                while ((line = br.readLine()) != null) {
                    String[] row = line.split(",", -1);
                    ComVariable apVariable = new ComVariable(row);
                    ComVariable variable = this.variables.get(i);
                    if (apVariable.getName().equals(variable.getName())) {
                        variable.setMask(apVariable.getMask());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public boolean removeInvalidVariables() {
        return this.variables.removeIf(variable -> !variable.isValidRecord());
    }

    public int getVariablesSize() {
        return this.variables.size();
    }

    @Deprecated
    public void seteReadVariables(String[] variablesName, boolean offOn) {
        block0: for (int i = 0; i < this.variables.size(); ++i) {
            for (String name : variablesName) {
                if (!this.variables.get(i).getName().equals(name)) continue;
                this.variables.get(i).seteRead(offOn);
                continue block0;
            }
        }
    }

    @Deprecated
    public void seteReadVariables(int[] idVariables, boolean offOn) {
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0) continue;
            this.variables.get(idVariables[i]).seteRead(offOn);
        }
    }

    public void seteReadVariables(ComVariable[] variables, boolean offOn) {
        for (ComVariable variable : variables) {
            variable.seteRead(offOn);
        }
    }

    public void seteWriteVariables(ComVariable[] variables, boolean offOn) {
        for (ComVariable variable : variables) {
            try {
                Double.parseDouble(variable.getValueToWrite());
                variable.seteWrite(offOn);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void seteWriteVariables(String[] variablesName, boolean offOn) {
        block0: for (int i = 0; i < this.variables.size(); ++i) {
            for (String name : variablesName) {
                if (!this.variables.get(i).getName().equals(name)) continue;
                this.variables.get(i).seteWrite(offOn);
                continue block0;
            }
        }
    }

    @Deprecated
    public void seteWriteVariables(int[] idVariables, boolean offOn) {
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0) continue;
            try {
                Double.parseDouble(this.variables.get(idVariables[i]).getValueToWrite());
                this.variables.get(idVariables[i]).seteWrite(offOn);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setReadOkVariables(ComVariable[] variables) {
        for (ComVariable variable : variables) {
            variable.setReadOk(false);
        }
    }

    public void setWriteOkVariables(ComVariable[] variables) {
        for (ComVariable variable : variables) {
            variable.setWriteOk(false);
        }
    }

    @Deprecated
    public void setReadOkVariables(int[] idVariables) {
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0) continue;
            this.variables.get(idVariables[i]).setReadOk(false);
        }
    }

    @Deprecated
    public int[] getnReadVariables(int[] idVariables) {
        int[] getnRead = new int[idVariables.length];
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0) continue;
            getnRead[i] = this.variables.get(idVariables[i]).getnRead();
        }
        return getnRead;
    }

    @Deprecated
    public void setWriteOkVariables(int[] idVariables) {
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0) continue;
            this.variables.get(idVariables[i]).setWriteOk(false);
        }
    }

    @Deprecated
    public boolean getVariablesRead(int[] idVariables) {
        boolean rst = true;
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0 || this.variables.get(idVariables[i]).isReadOk()) continue;
            rst = false;
            break;
        }
        return rst;
    }

    @Deprecated
    public boolean getVariablesRead(int[] idVariables, int[] old_nRead) {
        boolean rst = true;
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0 || this.variables.get(idVariables[i]).isReadOk(old_nRead[i])) continue;
            rst = false;
            break;
        }
        return rst;
    }

    @Deprecated
    public boolean getVariablesWritten(int[] idVariables) {
        boolean rst = true;
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] < 0 || this.variables.get(idVariables[i]).isWriteOk()) continue;
            rst = false;
            break;
        }
        return rst;
    }

    @Deprecated
    public int[] geVariablesId(String[] variablesName) {
        int[] rst = new int[variablesName.length];
        for (int i = 0; i < rst.length; ++i) {
            rst[i] = -1;
        }
        block1: for (int j = 0; j < rst.length; ++j) {
            int i = -1;
            for (ComVariable variable : this.variables) {
                ++i;
                if (rst[j] != -1 || !variable.isValidRecord() || !variable.getName().equals(variablesName[j])) continue;
                rst[j] = i;
                continue block1;
            }
        }
        return rst;
    }

    public ComVariable getVariable(String variableName) {
        ComVariable rst = null;
        for (ComVariable variable : this.variables) {
            if (!variable.getName().equals(variableName)) continue;
            rst = variable;
        }
        return rst;
    }

    public ComVariable[] getVariables(String[] variablesName) {
        ComVariable[] rst = null;
        ArrayList<ComVariable> listVariables = new ArrayList<ComVariable>();
        for (String variableName : variablesName) {
            ComVariable variable = this.getVariable(variableName);
            if (variable == null) continue;
            listVariables.add(variable);
        }
        rst = listVariables.toArray(new ComVariable[listVariables.size()]);
        return rst;
    }

    @Deprecated
    public String[] getFormattedValues(int[] idVariables) {
        String[] rst = new String[idVariables.length];
        for (int i = 0; i < idVariables.length; ++i) {
            if (idVariables[i] >= 0) {
                ComVariable variable = this.variables.get(idVariables[i]);
                if (variable.isValidRecord()) {
                    String dato;
                    Double Q;
                    Double K;
                    String maschera;
                    if (variable.getType().toUpperCase().equals("STRING")) {
                        rst[i] = variable.getValueRead();
                        continue;
                    }
                    int posizioneK = variable.getMask().indexOf("K");
                    int posizioneQ = variable.getMask().indexOf("Q");
                    if (posizioneK > 0) {
                        maschera = variable.getMask().substring(0, posizioneK);
                        if (posizioneQ > 0) {
                            K = Double.parseDouble(variable.getMask().substring(posizioneK + 1, posizioneQ));
                            Q = Double.parseDouble(variable.getMask().substring(posizioneQ + 1, variable.getMask().length()));
                        } else {
                            K = Double.parseDouble(variable.getMask().substring(posizioneK + 1, variable.getMask().length()));
                            Q = 0.0;
                        }
                    } else if (posizioneQ > 0) {
                        maschera = variable.getMask().substring(0, posizioneQ);
                        K = 1.0;
                        Q = Double.parseDouble(variable.getMask().substring(posizioneQ + 1, variable.getMask().length()));
                    } else {
                        maschera = variable.getMask();
                        K = 1.0;
                        Q = 0.0;
                    }
                    try {
                        dato = Double.toString(Double.parseDouble(variable.getValueRead()) / K - Q);
                    }
                    catch (NumberFormatException e) {
                        dato = variable.getValueRead();
                    }
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                    decimalFormatSymbols.setGroupingSeparator('\'');
                    decimalFormatSymbols.setDecimalSeparator('.');
                    DecimalFormat formatter = new DecimalFormat(maschera);
                    formatter.setDecimalFormatSymbols(decimalFormatSymbols);
                    formatter.setGroupingUsed(false);
                    if (variable.getType().toUpperCase().equals("INT") || variable.getType().toUpperCase().equals("DINT")) {
                        int posizioneVirgola = maschera.lastIndexOf(".");
                        if (posizioneVirgola > 0) {
                            posizioneVirgola = maschera.length() - posizioneVirgola - 1;
                        }
                        if (posizioneVirgola < 0) {
                            posizioneVirgola = 0;
                        }
                        try {
                            rst[i] = formatter.format(Double.parseDouble(dato) / Math.pow(10.0, posizioneVirgola));
                        }
                        catch (Exception e) {
                            rst[i] = "####";
                        }
                        continue;
                    }
                    try {
                        rst[i] = formatter.format(dato);
                    }
                    catch (Exception e) {
                        rst[i] = dato;
                    }
                    continue;
                }
                rst[i] = "####";
                continue;
            }
            rst[i] = "####";
        }
        return rst;
    }

    private void endScheduling() {
        try {
            if (this.ModbusMaster.isInitialized()) {
                this.ModbusMaster.destroy();
            }
            if (this.ModbusMasterTCPIP.isInitialized()) {
                this.ModbusMasterTCPIP.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startScheduling(int timerInterval) {
        if (this.schedulingCondition) {
            this.timerInterval = timerInterval;
            if (!this.extRUN) {
                this.extRUN = true;
                final Timer timer = new Timer("Scheduling", true);
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (!Comunication.this.extRUN) {
                            Comunication.this.endScheduling();
                            timer.cancel();
                        }
                    }
                };
                timer.schedule(timerTask, 0L, (long)timerInterval);
                if (this.schedulingConditions(2)) {
                    this.startFileRowScheduling(timerInterval);
                }
                if (this.schedulingConditions(4)) {
                    this.startFileColScheduling(timerInterval);
                }
                if (this.schedulingConditions(8)) {
                    this.startAPIScheduling(timerInterval);
                }
                if (this.schedulingConditions(3)) {
                    this.startModbusRTUScheduling(timerInterval);
                }
                if (this.schedulingConditions(7)) {
                    this.startModbusTCPIPScheduling(timerInterval);
                }
                if (this.schedulingConditions(5)) {
                    this.startSavioScheduling(timerInterval);
                }
            }
        }
    }

    private void startFileRowScheduling(int timerInterval) {
        final Timer timer = new Timer("FileRow", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningFileRow = true;
                    Comunication.this.fileRowScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningFileRow = false;
                    LOG.info("STOP FileRow");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START FileRow");
    }

    private void startFileColScheduling(int timerInterval) {
        final Timer timer = new Timer("FileCol", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningFileCol = true;
                    Comunication.this.fileColScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningFileCol = false;
                    LOG.info("STOP FileCol");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START FileCol");
    }

    private void startAPIScheduling(int timerInterval) {
        final Timer timer = new Timer("API", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningAPI = true;
                    Comunication.this.APIScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningAPI = false;
                    LOG.info("STOP API");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START API");
    }

    private void startModbusRTUScheduling(int timerInterval) {
        final Timer timer = new Timer("ModbusRTU", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningModbusRTU = true;
                    Comunication.this.modbusRTUScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningModbusRTU = false;
                    LOG.info("STOP ModbusRTU");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START ModbusRTU");
    }

    private void startModbusTCPIPScheduling(int timerInterval) {
        final Timer timer = new Timer("ModbusTCPIP", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningModbusTCPIP = true;
                    Comunication.this.modbusTCPIPScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningModbusTCPIP = false;
                    LOG.info("STOP ModbusTCPIP");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START ModbusTCPIP");
    }

    private void startSavioScheduling(int timerInterval) {
        final Timer timer = new Timer("Savio", true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Comunication.this.extRUN) {
                    Comunication.this.runningSavio = true;
                    Comunication.this.savioScheduling();
                } else {
                    timer.cancel();
                    Comunication.this.runningSavio = false;
                    LOG.info("STOP Savio");
                }
            }
        };
        timer.schedule(timerTask, 0L, (long)timerInterval);
        LOG.info("START Savio");
    }

    public void stopSchedulinig() {
        this.extRUN = false;
    }

    public boolean isRunning() {
        return this.runningFileRow || this.runningFileCol || this.runningModbusRTU || this.runningModbusTCPIP || this.runningSavio || this.runningAPI;
    }

    private boolean checkFileVariablesCoherence(ComVariable variable) {
        boolean rst = false;
        try {
            if (Integer.parseInt(variable.getAddress()) > 0) {
                switch (variable.getType().toUpperCase()) {
                    case "CHAR": 
                    case "BYTE": {
                        rst = true;
                        break;
                    }
                    case "INT": 
                    case "WORD": {
                        rst = true;
                        break;
                    }
                    case "DINT": 
                    case "DWORD": 
                    case "REAL": {
                        rst = true;
                        break;
                    }
                    case "BOOL": {
                        rst = true;
                        break;
                    }
                    case "STRING": {
                        rst = true;
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rst;
    }

    private boolean checkModbusVariablesCoherence(ComVariable variable) {
        boolean rst = false;
        block8 : switch (variable.getType().toUpperCase()) {
            case "INT": {
                if (!variable.getAddress().contains("QW ") && !variable.getAddress().contains("IW ") && !variable.getAddress().contains("MW ")) break;
                rst = true;
                break;
            }
            case "DINT": {
                if (!variable.getAddress().contains("QW ") && !variable.getAddress().contains("IW ") && !variable.getAddress().contains("MW ") && !variable.getAddress().contains("MD ")) break;
                rst = true;
                break;
            }
            case "BOOL": {
                if (!variable.getAddress().contains("QW ") && !variable.getAddress().contains("IW ") && !variable.getAddress().contains("MW ")) break;
                for (int i = 0; i < 16; ++i) {
                    if (!variable.getAddress().endsWith("X:" + i)) continue;
                    rst = true;
                    break block8;
                }
                break;
            }
            case "STRING": 
            case "STRING_U": {
                Pattern pattern;
                Matcher matcher;
                if (!variable.getAddress().startsWith("MC") || !(matcher = (pattern = Pattern.compile("MC(\\d+)\\s(\\d+)")).matcher(variable.getAddress())).find()) break;
                rst = true;
                break;
            }
            case "REAL": {
                if (!variable.getAddress().contains("MD ")) break;
                rst = true;
                break;
            }
        }
        return rst;
    }

    private boolean checkSavioVariablesCoherence(ComVariable variable) {
        boolean rst = false;
        String[] params = variable.getParams();
        if (params[1].equals("3")) {
            if (!params[2].equals("")) {
                rst = true;
            }
        } else if (params[1].equals("1") && Integer.parseInt(params[0]) > 0 && Integer.parseInt(params[0]) < 12) {
            rst = true;
        }
        return rst;
    }

    private boolean checkAPIVariablesCoherence(ComVariable variable) {
        boolean rst = false;
        String type = variable.getType().toUpperCase();
        String[] params = variable.getParams();
        if (params[0].length() > 0 && params[1].length() > 0) {
            rst = true;
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileRowScheduling() {
        int i;
        String rst = "";
        int Nvariabili = 0;
        String fileName = "";
        int readWrite = -1;
        if (this.IndiceVariabileSchedulazioneFileTestoRow >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneFileTestoRow = 0;
        }
        for (i = this.IndiceVariabileSchedulazioneFileTestoRow; i < this.variables.size(); ++i) {
            ComVariable variable = this.variables.get(i);
            if (variable.isValidRecord()) {
                Connection connection = this.connections.get(variable.getConnectionId());
                if (connection.getDriver() == 2) {
                    if (variable.iseWrite() || variable.iseRead()) {
                        int apReadWrite = variable.getValueToWrite().equals("") || !variable.iseWrite() ? 0 : 1;
                        if (readWrite == -1 || readWrite == apReadWrite) {
                            readWrite = apReadWrite;
                        }
                        if (Nvariabili > 0) {
                            if (!fileName.equals(connection.getParameters()[0])) break;
                            ++Nvariabili;
                            continue;
                        }
                        fileName = connection.getParameters()[0];
                        ++Nvariabili;
                        continue;
                    }
                    if (Nvariabili <= 0) continue;
                    break;
                }
                if (Nvariabili <= 0) continue;
                break;
            }
            if (Nvariabili > 0) break;
        }
        this.IndiceVariabileSchedulazioneFileTestoRow = i - Nvariabili;
        if (Nvariabili > 0) {
            ComVariable variable;
            List<Object> lines;
            block44: {
                lines = new ArrayList();
                try {
                    if (fileName.startsWith("smb")) {
                        SmbFile smbFile = new SmbFile(fileName);
                        try (SmbFileInputStream smbFileInputStream = new SmbFileInputStream(smbFile);
                             InputStreamReader isr = new InputStreamReader((InputStream)smbFileInputStream);
                             BufferedReader reader = new BufferedReader(isr);){
                            lines = reader.lines().collect(Collectors.toList());
                            break block44;
                        }
                    }
                    File file = new File(fileName);
                    lines = Files.readAllLines(file.toPath());
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
            for (i = 0; i < Nvariabili; ++i) {
                if (readWrite == 0) {
                    variable = this.variables.get(this.IndiceVariabileSchedulazioneFileTestoRow);
                    try {
                        variable.setValueRead((String)lines.get(Integer.parseInt(variable.getAddress()) - 1));
                    }
                    catch (Exception e) {
                        variable.setValueRead("####");
                    }
                    finally {
                        variable.setReadOk(true);
                        variable.incnRead();
                        variable.seteRead(false);
                    }
                    ++this.IndiceVariabileSchedulazioneFileTestoRow;
                    continue;
                }
                variable = this.variables.get(this.IndiceVariabileSchedulazioneFileTestoRow + i);
                Connection connection = this.connections.get(variable.getConnectionId());
                fileName = connection.getParameters()[0];
                int row = Integer.parseInt(variable.getAddress());
                for (int j = lines.size(); j < row; ++j) {
                    lines.add("");
                }
                lines.set(row - 1, variable.getValueToWrite());
            }
            if (readWrite == 1) {
                try {
                    if (fileName.startsWith("smb")) {
                        String output = String.join((CharSequence)"\n", lines);
                        SmbFile smbFile = new SmbFile(fileName);
                        SmbFileOutputStream smbFileOutPutStream = new SmbFileOutputStream(smbFile);
                        smbFileOutPutStream.write(output.getBytes());
                    } else {
                        Files.write(Paths.get(fileName, new String[0]), lines, new OpenOption[0]);
                    }
                    for (i = 0; i < Nvariabili; ++i) {
                        variable = this.variables.get(this.IndiceVariabileSchedulazioneFileTestoRow + i);
                        variable.setValueRead(variable.getValueToWrite());
                        variable.setValueToWrite("");
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
                finally {
                    for (i = 0; i < Nvariabili; ++i) {
                        ComVariable variable2 = this.variables.get(this.IndiceVariabileSchedulazioneFileTestoRow);
                        variable2.seteWrite(false);
                        variable2.setWriteOk(true);
                        ++this.IndiceVariabileSchedulazioneFileTestoRow;
                    }
                }
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileColScheduling() {
        int i;
        String rst = "";
        int Nvariabili = 0;
        String fileName = "";
        if (this.IndiceVariabileSchedulazioneFileTestoCol >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneFileTestoCol = 0;
        }
        String splitSeparator = ",";
        for (i = this.IndiceVariabileSchedulazioneFileTestoCol; i < this.variables.size(); ++i) {
            ComVariable variable = this.variables.get(i);
            if (variable.isValidRecord()) {
                Connection connection = this.connections.get(variable.getConnectionId());
                if (connection.getDriver() == 4) {
                    splitSeparator = connection.getParameters()[1];
                    if (variable.iseRead() && !variable.iseWrite()) {
                        if (Nvariabili > 0) {
                            if (!fileName.equals(connection.getParameters()[0])) break;
                            ++Nvariabili;
                            continue;
                        }
                        fileName = connection.getParameters()[0];
                        ++Nvariabili;
                        continue;
                    }
                    if (Nvariabili <= 0) continue;
                    break;
                }
                if (Nvariabili <= 0) continue;
                break;
            }
            if (Nvariabili > 0) break;
        }
        this.IndiceVariabileSchedulazioneFileTestoCol = i - Nvariabili;
        if (Nvariabili > 0) {
            String lastLine = "";
            String[] var = null;
            try {
                block37: {
                    if (fileName.startsWith("smb")) {
                        SmbFile smbFile = new SmbFile(fileName);
                        try (SmbFileInputStream smbFileInputStream = new SmbFileInputStream(smbFile);
                             InputStreamReader isr = new InputStreamReader((InputStream)smbFileInputStream);
                             BufferedReader reader = new BufferedReader(isr);){
                            lastLine = this.getLastLine(reader);
                            break block37;
                        }
                    }
                    FileReader fr = new FileReader(fileName);
                    try (BufferedReader reader = new BufferedReader(fr);){
                        lastLine = this.getLastLine(reader);
                    }
                }
                if (splitSeparator.equals("")) {
                    splitSeparator = ",";
                }
                var = lastLine.split(splitSeparator);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            for (i = 0; i < Nvariabili; ++i) {
                ComVariable variable = this.variables.get(this.IndiceVariabileSchedulazioneFileTestoCol);
                try {
                    variable.setValueRead((String)var[Integer.parseInt(variable.getAddress()) - 1]);
                }
                catch (Exception e) {
                    variable.setValueRead("####");
                }
                finally {
                    variable.setReadOk(true);
                    variable.incnRead();
                    variable.seteRead(false);
                }
                ++this.IndiceVariabileSchedulazioneFileTestoCol;
            }
        }
        return rst;
    }

    private String getLastLine(BufferedReader br) throws Exception {
        String lineNew;
        String line = "";
        while ((lineNew = br.readLine()) != null) {
            line = lineNew;
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String modbusRTUScheduling() {
        rst = "";
        Nvariabili = 0;
        portAddress = "";
        port = "";
        portParameters = "";
        variableType = "";
        startAddress = 0;
        offset = 0;
        values = new ArrayList<Short>();
        readWrite = -1;
        if (this.IndiceVariabileSchedulazioneModbusRTU >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneModbusRTU = 0;
        }
        for (i = this.IndiceVariabileSchedulazioneModbusRTU; i < this.variables.size(); ++i) {
            variable = this.variables.get(i);
            if (variable.isValidRecord()) {
                connection = this.connections.get(variable.getConnectionId());
                if (connection.getDriver() == 3) {
                    if (variable.iseRead() || variable.iseWrite()) {
                        apReadWrite = variable.getValueToWrite().equals("") != false || variable.iseWrite() == false ? 0 : 1;
                        if (readWrite == -1 || readWrite == apReadWrite) {
                            readWrite = apReadWrite;
                            if (Nvariabili == 0) {
                                port = connection.getParameters()[0];
                                portParameters = connection.getParameters()[1];
                                portAddress = connection.getParameters()[2];
                                variableType = variable.getAddress().trim().substring(0, 2);
                                start = variable.getAddress().indexOf(variableType + " ");
                                end = variable.getAddress().indexOf("X:");
                                startAddress = end > -1 ? Integer.parseInt(variable.getAddress().substring(start + 3, end)) : Integer.parseInt(variable.getAddress().substring(start + 3));
                            }
                            if (port.equals(connection.getParameters()[0]) && portParameters.equals(connection.getParameters()[1]) && portAddress.equals(connection.getParameters()[2]) && variableType.equals(variable.getAddress().trim().substring(0, 2))) {
                                inizio = variable.getAddress().indexOf(variableType + " ");
                                fine = variable.getAddress().indexOf("X:");
                                address = fine > -1 ? Integer.parseInt(variable.getAddress().substring(inizio + 3, fine)) : Integer.parseInt(variable.getAddress().substring(inizio + 3));
                                if (address != startAddress + offset) break;
                                ++offset;
                                if (variable.getType().toUpperCase().equals("DINT") || variable.getType().toUpperCase().equals("REAL")) {
                                    ++offset;
                                }
                                if (readWrite == 0) {
                                    ++Nvariabili;
                                    continue;
                                }
                                try {
                                    var18_30 = variable.getType().toUpperCase();
                                    var19_33 = -1;
                                    switch (var18_30.hashCode()) {
                                        case 72655: {
                                            if (!var18_30.equals("INT")) break;
                                            var19_33 = 0;
                                            break;
                                        }
                                        case 2098443: {
                                            if (!var18_30.equals("DINT")) break;
                                            var19_33 = 1;
                                            break;
                                        }
                                        case 2511262: {
                                            if (!var18_30.equals("REAL")) break;
                                            var19_33 = 2;
                                            break;
                                        }
                                    }
                                    switch (var19_33) {
                                        case 0: {
                                            values.add(Short.parseShort(variable.getValueToWrite()));
                                            break;
                                        }
                                        case 1: {
                                            bits = Integer.parseInt(variable.getValueToWrite());
                                            values.add((short)((long)bits & 65535L));
                                            values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                            break;
                                        }
                                        case 2: {
                                            bits = Float.floatToIntBits(Float.parseFloat(variable.getValueToWrite()));
                                            values.add((short)((long)bits & 65535L));
                                            values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Comunication.LOG.error((Object)e);
                                }
                                ++Nvariabili;
                                continue;
                            }
                            if (Nvariabili <= 0) continue;
                            break;
                        }
                        if (Nvariabili <= 0) continue;
                        break;
                    }
                    if (Nvariabili <= 0) continue;
                    break;
                }
                if (Nvariabili <= 0) continue;
                break;
            }
            if (Nvariabili > 0) break;
        }
        this.IndiceVariabileSchedulazioneModbusRTU = i - Nvariabili;
        if (Nvariabili <= 0) return rst;
        baudrate = 9600;
        parity = 0;
        dataBits = 8;
        stopBits = 1;
        try {
            parameters = portParameters.split("_");
            baudrate = Integer.parseInt(parameters[0]);
            if (parameters[1].equalsIgnoreCase("n")) {
                parity = 0;
            } else if (parameters[1].equalsIgnoreCase("o")) {
                parity = 1;
            } else if (parameters[1].equalsIgnoreCase("e")) {
                parity = 2;
            } else if (parameters[1].equalsIgnoreCase("m")) {
                parity = 3;
            } else if (parameters[1].equalsIgnoreCase("s")) {
                parity = 4;
            }
            dataBits = Integer.parseInt(parameters[2]);
            stopBits = Integer.parseInt(parameters[3]);
        }
        catch (Exception e) {
            Comunication.LOG.error((Object)e);
        }
        try {
            if (this.ModbusMaster.isInitialized()) {
                // empty if block
            }
        }
        catch (Exception e) {
            modbusFactory = new ModbusFactory();
            spw = new SerialPortWrapperImpl_jssc(port, baudrate, 0, dataBits, stopBits, parity);
            this.ModbusMaster = modbusFactory.createRtuMaster((SerialPortWrapper)spw, 0L, 0L);
            this.ModbusMaster.setRetries(1);
            this.ModbusMaster.setTimeout(50);
            try {
                this.ModbusMaster.init();
            }
            catch (Exception var19_34) {
                // empty catch block
            }
        }
        if (readWrite != 0) {
            try {
                shValues = new short[values.size()];
                for (j = 0; j < shValues.length; ++j) {
                    shValues[j] = (Short)values.get(j);
                }
                request = new WriteRegistersRequest(Integer.parseInt(portAddress), startAddress, shValues);
                response = (WriteRegistersResponse)this.ModbusMaster.send((ModbusRequest)request);
                if (response.isException()) return rst;
                for (i = 0; i < Nvariabili; ++i) {
                    apVariabile = this.variables.get(this.IndiceVariabileSchedulazioneModbusRTU + i);
                    apVariabile.setValueRead(apVariabile.getValueToWrite());
                    apVariabile.setValueToWrite("");
                }
                return rst;
            }
            catch (Exception e) {
                Comunication.LOG.error((Object)e);
            }
            finally {
                for (i = 0; i < Nvariabili; ++this.IndiceVariabileSchedulazioneModbusRTU, ++i) {
                    variable = this.variables.get(this.IndiceVariabileSchedulazioneModbusRTU);
                    variable.seteWrite(false);
                    variable.setWriteOk(true);
                }
                return rst;
            }
        } else {
            alRisposta = new ArrayList<String>();
            try {
                request = new ReadHoldingRegistersRequest(Integer.parseInt(portAddress), startAddress, offset);
                response = (ReadHoldingRegistersResponse)this.ModbusMaster.send((ModbusRequest)request);
                if (response.isException()) {
                    Comunication.LOG.error("Exception response: message=" + response.getExceptionMessage());
                }
                apShort = response.getShortData();
                for (i = 0; i < apShort.length; ++i) {
                    alRisposta.add(String.valueOf(apShort[i]));
                }
            }
            catch (Exception e) {
                Comunication.LOG.error((Object)e);
            }
            for (i = 0; i < Nvariabili; ++this.IndiceVariabileSchedulazioneModbusRTU, ++i) {
                apVariabile = this.variables.get(this.IndiceVariabileSchedulazioneModbusRTU);
                try {
                    response = apVariabile.getType().toUpperCase();
                    apShort = -1;
                    switch (response.hashCode()) {
                        case 72655: {
                            if (!response.equals("INT")) break;
                            apShort = 0;
                            break;
                        }
                        case 2098443: {
                            if (!response.equals("DINT")) break;
                            apShort = 1;
                            break;
                        }
                        case 2511262: {
                            if (!response.equals("REAL")) break;
                            apShort = 2;
                            break;
                        }
                        case 2044650: {
                            if (!response.equals("BOOL")) break;
                            apShort = 3;
                            break;
                        }
                    }
                    switch (apShort) {
                        case 0: {
                            apVariabile.setValueRead((String)alRisposta.get(i));
                            ** break;
lbl203:
                            // 1 sources

                            break;
                        }
                        case 1: {
                            sHig = Short.parseShort((String)alRisposta.get(i));
                            sLow = Short.parseShort((String)alRisposta.get(++i));
                            iHig = (sHig & 65535) << 16;
                            iLow = sLow & 65535;
                            apVariabile.setValueRead(String.valueOf(iHig | iLow));
                            ** break;
lbl211:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            sLow = Short.parseShort((String)alRisposta.get(i));
                            sHig = Short.parseShort((String)alRisposta.get(++i));
                            iHig = (sHig & 65535) << 16;
                            iLow = sLow & 65535;
                            apVariabile.setValueRead(String.valueOf(Float.intBitsToFloat(iHig | iLow)));
                            ** break;
lbl219:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            value = (String)alRisposta.get(i);
                            isBit = apVariabile.getAddress().indexOf("X:");
                            if (isBit > -1) {
                                bit = Integer.parseInt(apVariabile.getAddress().substring(isBit + 2));
                                value = BigInteger.valueOf(Long.parseLong(value)).testBit(bit) != false ? "1" : "0";
                            }
                            apVariabile.setValueRead(value);
                            ** break;
lbl228:
                            // 1 sources

                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    apVariabile.setValueRead("####");
                    continue;
                }
                finally {
                    apVariabile.setReadOk(true);
                    apVariabile.incnRead();
                    apVariabile.seteRead(false);
                }
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String modbusTCPIPScheduling() {
        rst = "";
        Nvariabili = 0;
        serverAddress = "";
        port = "";
        slaveId = 1;
        swapw = false;
        littleEndian = false;
        variableType = "";
        startAddress = 0;
        offset = 0;
        values = new ArrayList<Short>();
        readWrite = -1;
        if (this.IndiceVariabileSchedulazioneModbusTCPIP >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneModbusTCPIP = 0;
        }
        for (i = this.IndiceVariabileSchedulazioneModbusTCPIP; i < this.variables.size(); ++i) {
            variable = this.variables.get(i);
            if (variable.isValidRecord()) {
                connection = this.connections.get(variable.getConnectionId());
                if (connection.getDriver() == 7) {
                    if (variable.iseRead() || variable.iseWrite()) {
                        apReadWrite = variable.getValueToWrite().equals("") != false || variable.iseWrite() == false ? 0 : 1;
                        if (readWrite == -1 || readWrite == apReadWrite) {
                            readWrite = apReadWrite;
                            if (Nvariabili == 0) {
                                serverAddress = connection.getParameters()[0];
                                port = connection.getParameters()[1];
                                try {
                                    slaveId = Integer.parseInt(connection.getParameters()[2]);
                                }
                                catch (Exception var17_30) {
                                    // empty catch block
                                }
                                flags = connection.getParameters()[3].split("|", -1);
                                swapw = Arrays.asList(flags).contains("SWAP_WORD");
                                littleEndian = Arrays.asList(flags).contains("LITTLE_ENDIAN");
                                variableType = variable.getAddress().trim().substring(0, 1);
                                variablePrefix = variable.getAddress().trim().substring(0, 2);
                                if (variablePrefix.equalsIgnoreCase("MC")) {
                                    pattern = Pattern.compile("MC(\\d+)\\s(\\d+)");
                                    matcher = pattern.matcher(variable.getAddress());
                                    matcher.find();
                                    start = Integer.parseInt(matcher.group(2));
                                    nword = Integer.parseInt(matcher.group(1)) / 2;
                                    startAddress = start;
                                } else {
                                    start = variable.getAddress().indexOf(variablePrefix + " ");
                                    end = variable.getAddress().indexOf("X:");
                                    startAddress = end > -1 ? Integer.parseInt(variable.getAddress().substring(start + 3, end)) : Integer.parseInt(variable.getAddress().substring(start + 3));
                                }
                            }
                            if (serverAddress.equals(connection.getParameters()[0]) && port.equals(connection.getParameters()[1]) && variableType.equals(variable.getAddress().trim().substring(0, 1))) {
                                prefissoVariabile = variable.getAddress().trim().substring(0, 2);
                                nword = 0;
                                if (prefissoVariabile.equalsIgnoreCase("MC")) {
                                    pattern = Pattern.compile("MC(\\d+)\\s(\\d+)");
                                    matcher = pattern.matcher(variable.getAddress());
                                    matcher.find();
                                    inizio = Integer.parseInt(matcher.group(2));
                                    nword = Integer.parseInt(matcher.group(1)) / 2;
                                    address = inizio;
                                } else {
                                    inizio = variable.getAddress().indexOf(prefissoVariabile + " ");
                                    fine = variable.getAddress().indexOf("X:");
                                    address = fine > -1 ? Integer.parseInt(variable.getAddress().substring(inizio + 3, fine)) : Integer.parseInt(variable.getAddress().substring(inizio + 3));
                                }
                                if (address != startAddress + offset) break;
                                ++offset;
                                if (variable.getType().toUpperCase().equals("DINT") || variable.getType().toUpperCase().equals("REAL")) {
                                    ++offset;
                                } else if (variable.getType().toUpperCase().equals("STRING")) {
                                    offset = offset + nword - 1;
                                }
                                if (readWrite == 0) {
                                    ++Nvariabili;
                                    continue;
                                }
                                try {
                                    pattern = variable.getType().toUpperCase();
                                    matcher = -1;
                                    switch (pattern.hashCode()) {
                                        case 72655: {
                                            if (!pattern.equals("INT")) break;
                                            matcher = 0;
                                            break;
                                        }
                                        case 2098443: {
                                            if (!pattern.equals("DINT")) break;
                                            matcher = 1;
                                            break;
                                        }
                                        case 2511262: {
                                            if (!pattern.equals("REAL")) break;
                                            matcher = 2;
                                            break;
                                        }
                                        case -1838656495: {
                                            if (!pattern.equals("STRING")) break;
                                            matcher = 3;
                                            break;
                                        }
                                        case -1717330009: {
                                            if (!pattern.equals("STRING_U")) break;
                                            matcher = 4;
                                            break;
                                        }
                                    }
                                    switch (matcher) {
                                        case 0: {
                                            values.add(Short.parseShort(variable.getValueToWrite()));
                                            break;
                                        }
                                        case 1: {
                                            bits = Integer.parseInt(variable.getValueToWrite());
                                            if (swapw) {
                                                values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                                values.add((short)((long)bits & 65535L));
                                                break;
                                            }
                                            values.add((short)((long)bits & 65535L));
                                            values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                            break;
                                        }
                                        case 2: {
                                            bits = Float.floatToIntBits(Float.parseFloat(variable.getValueToWrite()));
                                            if (swapw) {
                                                values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                                values.add((short)((long)bits & 65535L));
                                                break;
                                            }
                                            values.add((short)((long)bits & 65535L));
                                            values.add((short)(((long)bits & 0xFFFF0000L) >> 16));
                                            break;
                                        }
                                        case 3: {
                                            s = variable.getValueToWrite();
                                            for (j = 0; j < s.length(); j += 2) {
                                                c = s.charAt(j);
                                                ascii = (short)c;
                                                ascii = (short)(ascii << 8);
                                                if (j + 1 < s.length()) {
                                                    ascii = (short)(ascii | (short)s.charAt(j + 1));
                                                }
                                                values.add(ascii);
                                            }
                                            break;
                                        }
                                        case 4: {
                                            s = variable.getValueToWrite();
                                            for (j = 0; j < s.length(); ++j) {
                                                c = s.charAt(j);
                                                ascii = (short)c;
                                                values.add(ascii);
                                            }
                                            break;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Comunication.LOG.error((Object)e);
                                }
                                ++Nvariabili;
                                continue;
                            }
                            if (Nvariabili <= 0) continue;
                            break;
                        }
                        if (Nvariabili <= 0) continue;
                        break;
                    }
                    if (Nvariabili <= 0) continue;
                    break;
                }
                if (Nvariabili <= 0) continue;
                break;
            }
            if (Nvariabili > 0) break;
        }
        this.IndiceVariabileSchedulazioneModbusTCPIP = i - Nvariabili;
        if (Nvariabili <= 0) return rst;
        try {
            if (this.ModbusMasterTCPIP.isInitialized()) {
                // empty if block
            }
        }
        catch (Exception e) {
            modbusFactory = new ModbusFactory();
            params = new IpParameters();
            params.setHost(serverAddress);
            params.setPort(Integer.parseInt(port));
            this.ModbusMasterTCPIP = modbusFactory.createTcpMaster(params, true);
            this.ModbusMasterTCPIP.setRetries(0);
            this.ModbusMasterTCPIP.setTimeout(2000);
            try {
                this.ModbusMasterTCPIP.init();
            }
            catch (Exception prefissoVariabile) {
                // empty catch block
            }
        }
        if (readWrite != 0) {
            try {
                shValues = new short[values.size()];
                for (j = 0; j < shValues.length; ++j) {
                    shValues[j] = (Short)values.get(j);
                }
                request = new WriteRegistersRequest(slaveId, startAddress, shValues);
                response = (WriteRegistersResponse)this.ModbusMasterTCPIP.send((ModbusRequest)request);
                if (response.isException()) return rst;
                for (i = 0; i < Nvariabili; ++i) {
                    apVariabile = this.variables.get(this.IndiceVariabileSchedulazioneModbusTCPIP + i);
                    apVariabile.setValueRead(apVariabile.getValueToWrite());
                    apVariabile.setValueToWrite("");
                }
                return rst;
            }
            catch (Exception e) {
                Comunication.LOG.error((Object)e);
            }
            finally {
                for (i = 0; i < Nvariabili; ++this.IndiceVariabileSchedulazioneModbusTCPIP, ++i) {
                    variable = this.variables.get(this.IndiceVariabileSchedulazioneModbusTCPIP);
                    variable.seteWrite(false);
                    variable.setWriteOk(true);
                }
                return rst;
            }
        }
        alRisposta = new ArrayList<String>();
        try {
            request = new ReadHoldingRegistersRequest(slaveId, startAddress, offset);
            response = (ReadHoldingRegistersResponse)this.ModbusMasterTCPIP.send((ModbusRequest)request);
            if (response.isException()) {
                Comunication.LOG.error("Exception response: message=" + response.getExceptionMessage());
            } else {
                apShort = response.getShortData();
                for (i = 0; i < ((short[])apShort).length; ++i) {
                    alRisposta.add(String.valueOf(apShort[i]));
                }
            }
        }
        catch (Exception e) {
            Comunication.LOG.error((Object)e);
        }
        ofset = 0;
        for (i = 0; i < Nvariabili; ++this.IndiceVariabileSchedulazioneModbusTCPIP, ++i) {
            apVariabile = this.variables.get(this.IndiceVariabileSchedulazioneModbusTCPIP);
            try {
                apShort = apVariabile.getType().toUpperCase();
                var18_35 = -1;
                switch (apShort.hashCode()) {
                    case 72655: {
                        if (!apShort.equals("INT")) break;
                        var18_35 = 0;
                        break;
                    }
                    case 2098443: {
                        if (!apShort.equals("DINT")) break;
                        var18_35 = 1;
                        break;
                    }
                    case 2511262: {
                        if (!apShort.equals("REAL")) break;
                        var18_35 = 2;
                        break;
                    }
                    case -1838656495: {
                        if (!apShort.equals("STRING")) break;
                        var18_35 = 3;
                        break;
                    }
                }
                switch (var18_35) {
                    case 0: {
                        apVariabile.setValueRead((String)alRisposta.get(i + ofset));
                        ofset += 0;
                        ** break;
lbl256:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        if (swapw) {
                            sLow = Short.parseShort((String)alRisposta.get(i + ofset));
                            sHig = Short.parseShort((String)alRisposta.get(++i + ofset));
                        } else {
                            sHig = Short.parseShort((String)alRisposta.get(i + ofset));
                            sLow = Short.parseShort((String)alRisposta.get(++i + ofset));
                        }
                        iHig = (sHig & 65535) << 16;
                        iLow = sLow & 65535;
                        apVariabile.setValueRead(String.valueOf(iHig | iLow));
                        ++ofset;
                        ** break;
lbl269:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        if (swapw) {
                            sLow = Short.parseShort((String)alRisposta.get(i + ofset));
                            sHig = Short.parseShort((String)alRisposta.get(++i + ofset));
                        } else {
                            sHig = Short.parseShort((String)alRisposta.get(i + ofset));
                            sLow = Short.parseShort((String)alRisposta.get(++i + ofset));
                        }
                        iHig = (sHig & 65535) << 16;
                        iLow = sLow & 65535;
                        apVariabile.setValueRead(String.valueOf(Float.intBitsToFloat(iHig | iLow)));
                        ++ofset;
                        ** break;
lbl282:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        pattern = Pattern.compile("MC(\\d+)\\s(\\d+)");
                        matcher = pattern.matcher(apVariabile.getAddress());
                        matcher.find();
                        nword = Integer.parseInt(matcher.group(1)) / 2;
                        ap = "";
                        for (ii = 0; ii < nword; ++ofset, ++ii) {
                            cLow = (char)(Short.parseShort((String)alRisposta.get(i + ofset)) >> 8 & 255);
                            cHig = (char)(Short.parseShort((String)alRisposta.get(i + ofset)) & 255);
                            ap = ap + String.valueOf(cHig) + String.valueOf(cLow);
                        }
                        --ofset;
                        apVariabile.setValueRead(ap);
                        ** break;
lbl298:
                        // 1 sources

                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                apVariabile.setValueRead("####");
                continue;
            }
            finally {
                apVariabile.setReadOk(true);
                apVariabile.incnRead();
                apVariabile.seteRead(false);
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void APIScheduling() {
        if (this.IndiceVariabileSchedulazioneAPI >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneAPI = 0;
        }
        int i = 0;
        for (i = this.IndiceVariabileSchedulazioneAPI; i < this.variables.size(); ++i) {
            Connection connection;
            ComVariable variable = this.variables.get(i);
            String response = "";
            if (!variable.isValidRecord() || (connection = this.connections.get(variable.getConnectionId())).getDriver() != 8 || !variable.iseRead() || variable.iseWrite()) continue;
            String[] params = connection.getParameters();
            String[] variableParams = variable.getParams();
            String value = "####";
            try {
                String lines;
                String[] connectionParams = connection.getParameters();
                String authString = connectionParams[1] + ":" + connectionParams[2];
                byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
                String authStringEnc = new String(authEncBytes);
                URL url = new URL(params[0] + "/" + variableParams[1]);
                URLConnection urlConnection = url.openConnection();
                urlConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
                urlConnection.setRequestProperty("Cache-Control", "no-cache");
                urlConnection.setUseCaches(false);
                BufferedReader input = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuffer APIResponse = new StringBuffer();
                while ((lines = input.readLine()) != null) {
                    APIResponse.append(lines);
                }
                response = APIResponse.toString();
                value = this.parseAPIResponse(variable, response);
                input.close();
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e);
                continue;
            }
            finally {
                variable.setValueRead(value);
                variable.setReadOk(true);
                variable.incnRead();
                variable.seteRead(false);
            }
        }
        this.IndiceVariabileSchedulazioneAPI = i;
    }

    private JSONObject getFinalObject(JSONObject obj, String[] keys) {
        if (keys.length > 1) {
            String[] partialKeys = new String[keys.length - 1];
            System.arraycopy(keys, 1, partialKeys, 0, keys.length - 1);
            obj = this.getFinalObject(obj.getJSONObject(keys[0]), partialKeys);
        }
        return obj;
    }

    private String parseAPIResponse(ComVariable variable, String response) throws Exception {
        String value = response;
        String fullKey = variable.getParams()[2];
        if (fullKey != null && !fullKey.isEmpty()) {
            String[] keys = fullKey.split("\\.");
            JSONObject obj = new JSONObject(response);
            obj = this.getFinalObject(obj, keys);
            switch (variable.getType().toUpperCase()) {
                case "INT": 
                case "DINT": 
                case "REAL": {
                    value = String.valueOf(obj.getNumber(keys[keys.length - 1]));
                    break;
                }
                case "STRING": {
                    value = String.valueOf(obj.getString(keys[keys.length - 1]));
                    break;
                }
                case "BOOL": {
                    value = String.valueOf(obj.getBoolean(keys[keys.length - 1]));
                    break;
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String savioScheduling() {
        if (this.IndiceVariabileSchedulazioneSavio >= this.variables.size()) {
            this.IndiceVariabileSchedulazioneSavio = 0;
        }
        String rst = "";
        ArrayList<ComVariable> variablesToRead = new ArrayList<ComVariable>();
        Connection connectionToRead = null;
        String savioType = "";
        int counter = 0;
        String soapResponse = "";
        ArrayList<String> tagsName = new ArrayList<String>();
        ArrayList<String> indexList = new ArrayList<String>();
        int firstNumber = 0;
        int lastNumber = 0;
        int i = 0;
        block15: for (i = this.IndiceVariabileSchedulazioneSavio; i < this.variables.size(); ++i) {
            Connection connection;
            ComVariable variable = this.variables.get(i);
            if (!variable.isValidRecord() || (connection = this.connections.get(variable.getConnectionId())).getDriver() != 5 || !variable.iseRead() || variable.iseWrite()) continue;
            if (connectionToRead == null) {
                connectionToRead = connection;
                savioType = variable.getParams()[1];
                if (savioType.equals("3")) {
                    firstNumber = Integer.parseInt(variable.getParams()[2]);
                    lastNumber = Integer.parseInt(variable.getParams()[2]);
                }
                indexList.add(variable.getParams()[0]);
                variablesToRead.add(variable);
                ++counter;
                continue;
            }
            if (connectionToRead != connection) continue;
            if (!variable.getParams()[1].equals(savioType)) break;
            switch (savioType) {
                case "1": {
                    if (!indexList.stream().anyMatch(tag -> tag.equals(variable.getParams()[0]))) {
                        indexList.add(variable.getParams()[0]);
                    }
                    variablesToRead.add(variable);
                    ++counter;
                    continue block15;
                }
                case "3": {
                    int variableNumber = Integer.parseInt(variable.getParams()[2]);
                    if (firstNumber > variableNumber || variableNumber > lastNumber + 1) continue block15;
                    if (variableNumber > lastNumber) {
                        lastNumber = variableNumber;
                    }
                    if (!indexList.stream().anyMatch(tag -> tag.equals(variable.getParams()[0]))) {
                        indexList.add(variable.getParams()[0]);
                    }
                    variablesToRead.add(variable);
                    ++counter;
                }
            }
        }
        this.IndiceVariabileSchedulazioneSavio = i;
        if (variablesToRead.size() > 0) {
            String savioHead = "<sav:GetSavioData><sav:subscription><sav:code>-1</sav:code><sav:timeout>5000</sav:timeout></sav:subscription><sav:shift>0</sav:shift>";
            String savioFoot = "</sav:GetSavioData>";
            String savioXML = "";
            HashMap<String, String> machineData = new HashMap<String, String>();
            for (int k = 0; k < indexList.size(); ++k) {
                savioXML = savioXML + "<sav:index>" + (String)indexList.get(k) + "</sav:index>";
                if (!savioType.equals("1")) continue;
                machineData.put((String)indexList.get(k), "0");
            }
            if (savioType.equals("3")) {
                savioXML = savioXML + "<sav:type>" + savioType + "</sav:type><sav:number>" + firstNumber + "</sav:number><sav:number_last>" + lastNumber + "</sav:number_last>";
            }
            savioXML = savioHead + savioXML + savioFoot;
            ArrayList<Object> convertedResponse = new ArrayList();
            try {
                soapResponse = this.sendSoapRequest(savioXML, connectionToRead);
                tagsName.add("mns:index");
                tagsName.add("mns:value");
                convertedResponse = this.soapResponseConverter(soapResponse, tagsName);
            }
            catch (Exception e) {
                for (int k = 0; k < variablesToRead.size(); ++k) {
                    ((ComVariable)variablesToRead.get(k)).setValueRead("####");
                }
            }
            for (int k = 0; k < variablesToRead.size(); ++k) {
                ComVariable variable = (ComVariable)variablesToRead.get(k);
                try {
                    int index;
                    if (savioType.equals("3")) {
                        index = (Integer.parseInt(variable.getParams()[2]) - firstNumber) * indexList.size() * 2;
                        boolean isValueSet = false;
                        for (int j = 0; j < indexList.size() && !isValueSet; ++j) {
                            if (!variable.getParams()[0].equals(((Map.Entry)convertedResponse.get(index + j * 2)).getValue()) || !((String)((Map.Entry)convertedResponse.get(index + j * 2)).getKey()).equals("mns:index") || !((String)((Map.Entry)convertedResponse.get(index + j * 2 + 1)).getKey()).equals("mns:value")) continue;
                            variable.setValueRead((String)((Map.Entry)convertedResponse.get(index + j * 2 + 1)).getValue());
                            isValueSet = true;
                        }
                    }
                    if (!savioType.equals("1")) continue;
                    index = k * 2;
                    if (!variable.getParams()[0].equals(((Map.Entry)convertedResponse.get(index)).getValue()) || !((String)((Map.Entry)convertedResponse.get(index)).getKey()).equals("mns:index") || !((String)((Map.Entry)convertedResponse.get(index + 1)).getKey()).equals("mns:value")) continue;
                    machineData.put((String)((Map.Entry)convertedResponse.get(index)).getValue(), (String)((Map.Entry)convertedResponse.get(index + 1)).getValue());
                    variable.setValueRead((String)machineData.get(((Map.Entry)convertedResponse.get(index)).getValue()));
                    continue;
                }
                catch (Exception e) {
                    variable.setValueRead("####");
                    continue;
                }
                finally {
                    variable.setReadOk(true);
                    variable.incnRead();
                    variable.seteRead(false);
                }
            }
        }
        return rst;
    }

    private ArrayList<Map.Entry<String, String>> soapResponseConverter(String soapResponse, ArrayList<String> tagsName) throws Exception {
        Node lastVisitedNode;
        Document soapDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(soapResponse)));
        DocumentTraversal soapTraversal = (DocumentTraversal)((Object)soapDoc);
        TreeWalker docWalker = soapTraversal.createTreeWalker(soapDoc, -1, null, true);
        ArrayList<Map.Entry<String, String>> convertedResponse = new ArrayList<Map.Entry<String, String>>();
        do {
            if (docWalker.getCurrentNode().getNodeName().equals("SOAP-ENV:Fault")) {
                LOG.error("Error on conversion: SOAP-ENV:Fault");
                throw new Exception("Error on conversion: SOAP-ENV:Fault");
            }
            if (!tagsName.stream().anyMatch(tag -> tag.equals(docWalker.getCurrentNode().getNodeName()))) {
                lastVisitedNode = docWalker.getCurrentNode();
                docWalker.nextNode();
                continue;
            }
            lastVisitedNode = docWalker.getCurrentNode();
            AbstractMap.SimpleEntry<String, String> node = new AbstractMap.SimpleEntry<String, String>(docWalker.getCurrentNode().getNodeName(), docWalker.nextNode().getNodeValue());
            convertedResponse.add(node);
            docWalker.nextNode();
        } while (docWalker.getCurrentNode() != lastVisitedNode);
        return convertedResponse;
    }

    private String sendSoapRequest(String xml, Connection connectionToRead) throws Exception {
        String soapHead = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:sav=\"http://localhost/savio_data/savio_interface.wsdl\"><soapenv:Header/><soapenv:Body>";
        String soapFoot = "</soapenv:Body></soapenv:Envelope>";
        String request = soapHead + xml + soapFoot;
        String response = "";
        try {
            String lines;
            String url = "http://" + connectionToRead.getParameters()[0];
            URL soapUrl = new URL(url);
            HttpURLConnection soapConnection = (HttpURLConnection)soapUrl.openConnection();
            soapConnection.setRequestMethod("POST");
            soapConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            soapConnection.setRequestProperty("SOAPAction", "\"http://localhost/savio_data/savio_interface.wsdl/GetSavioData\"");
            soapConnection.setDoOutput(true);
            DataOutputStream output = new DataOutputStream(soapConnection.getOutputStream());
            output.writeBytes(request);
            output.flush();
            output.close();
            if (soapConnection.getResponseCode() != 200) {
                throw new Exception("Soap response status error: " + soapConnection.getResponseMessage());
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(soapConnection.getInputStream()));
            StringBuffer soapResponse = new StringBuffer();
            while ((lines = input.readLine()) != null) {
                soapResponse.append(lines);
            }
            response = soapResponse.toString();
            input.close();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return response;
    }

    @Deprecated
    public String[] readVariables(String[] variablesName, int timerInterval, boolean appEND) {
        int[] variablesId = this.geVariablesId(variablesName);
        return this.readVariables(variablesId, appEND);
    }

    @Deprecated
    public String[] readVariables(int[] variablesId, boolean appEND) {
        this.setReadOkVariables(variablesId);
        int[] nRead = this.getnReadVariables(variablesId);
        int iCicliTimeOut = 20000 / this.timerInterval;
        while (!this.getVariablesRead(variablesId, nRead) && !appEND && iCicliTimeOut > 0) {
            this.seteReadVariables(variablesId, true);
            --iCicliTimeOut;
            try {
                Thread.sleep(this.timerInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.getFormattedValues(variablesId);
    }

    private void setValuesToWrite(ArrayList<ComVariable> variables) {
        for (ComVariable variable : variables) {
            variable.setValueToWrite(variable.getValue());
        }
    }

    @Deprecated
    private void setValuesToWrite(int[] variablesId, String[] variablesValue) {
        for (int i = 0; i < variablesId.length; ++i) {
            if (variablesId[i] < 0) continue;
            ComVariable variable = this.variables.get(variablesId[i]);
            variable.setValueToWrite(variablesValue[i]);
        }
    }

    @Deprecated
    public boolean checkVariablesWritten(int[] variablesId, boolean appEND) {
        boolean ret = true;
        int iCicliTimeOut = 20000 / this.timerInterval;
        while (!this.getVariablesWritten(variablesId) && !appEND && iCicliTimeOut > 0) {
            --iCicliTimeOut;
            try {
                Thread.sleep(this.timerInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        return ret;
    }

    @Deprecated
    public void writeVariables(String[] variablesName, String[] variablesValue) {
        int[] variablesId = this.geVariablesId(variablesName);
        this.writeVariables(variablesId, variablesValue);
    }

    @Deprecated
    public void writeVariables(int[] variablesId, String[] variablesValue) {
        this.setValuesToWrite(variablesId, this.setFormattedValues(variablesId, variablesValue));
        this.seteWriteVariables(variablesId, true);
    }

    @Deprecated
    public void writeVariables(int[] variablesId, String[] variablesValue, boolean AppEND) {
        this.setWriteOkVariables(variablesId);
        this.writeVariables(variablesId, variablesValue);
        this.checkVariablesWritten(variablesId, AppEND);
    }

    public boolean getVariablesRead(ComVariable[] variables) {
        boolean rst = true;
        for (ComVariable variable : variables) {
            if (variable.isReadOk()) continue;
            rst = false;
            break;
        }
        return rst;
    }

    public boolean getVariablesWrite(ComVariable[] variables) {
        boolean rst = true;
        for (ComVariable variable : variables) {
            if (variable.isWriteOk()) continue;
            rst = false;
            break;
        }
        return rst;
    }

    public String[] getFormattedValues(ComVariable[] variables) {
        String[] rst = new String[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            rst[i] = variables[i].getFormattedValue();
        }
        return rst;
    }

    public void setFormattedValues(ComVariable[] variables, String[] variablesValue) {
        String[] rst = new String[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            variables[i].setFormattedValue(variablesValue[i]);
        }
    }

    @Deprecated
    public String[] readVariables(ComVariable[] variables, boolean appEND) {
        AtomicBoolean ab = new AtomicBoolean(appEND);
        return this.readVariables(variables, ab);
    }

    public String[] readVariables(ComVariable[] variables, AtomicBoolean appEND) {
        this.setReadOkVariables(variables);
        int iCicliTimeOut = 20000 / this.timerInterval;
        while (!this.getVariablesRead(variables) && !appEND.get() && iCicliTimeOut > 0) {
            this.seteReadVariables(variables, true);
            --iCicliTimeOut;
            try {
                Thread.sleep(this.timerInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.getFormattedValues(variables);
    }

    @Deprecated
    public void readVariables(ArrayList<ComVariable> variables, boolean appEND) {
        AtomicBoolean ab = new AtomicBoolean(appEND);
        this.readVariables(variables, ab);
    }

    public ArrayList<Integer> getnReadVariables(ArrayList<ComVariable> variables) {
        return variables.stream().mapToInt(variable -> variable.getnRead()).collect(ArrayList::new, List::add, List::addAll);
    }

    public boolean getVariablesRead(ArrayList<ComVariable> variables, ArrayList<Integer> old_nRead) {
        boolean rst = true;
        for (int i = 0; i < variables.size(); ++i) {
            if (variables.get(i).isReadOk(old_nRead.get(i).intValue())) continue;
            rst = false;
            break;
        }
        return rst;
    }

    public void seteReadVariables(ArrayList<ComVariable> variables, boolean offOn) {
        variables.forEach(variable -> variable.seteRead(offOn));
    }

    public void readVariables(ArrayList<ComVariable> variables, AtomicBoolean appEND) {
        ArrayList<Integer> nReads = this.getnReadVariables(variables);
        int iCicliTimeOut = 20000 / this.timerInterval;
        while (!this.getVariablesRead(variables, nReads) && !appEND.get() && iCicliTimeOut > 0) {
            this.seteReadVariables(variables, true);
            --iCicliTimeOut;
            try {
                Thread.sleep(this.timerInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Deprecated
    public void WriteVariables(ArrayList<ComVariable> variables, boolean appEND) {
        AtomicBoolean ab = new AtomicBoolean(appEND);
        this.WriteVariables(variables, ab);
    }

    public void WriteVariables(ArrayList<ComVariable> variables, AtomicBoolean appEND) {
        ComVariable[] avariables = (ComVariable[])variables.stream().toArray(ComVariable[]::new);
        this.setWriteOkVariables(avariables);
        this.setValuesToWrite(variables);
        int iCicliTimeOut = 20000 / this.timerInterval;
        while (!this.getVariablesWrite(avariables) && !appEND.get() && iCicliTimeOut > 0) {
            this.seteWriteVariables(avariables, true);
            --iCicliTimeOut;
            try {
                Thread.sleep(this.timerInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.seteWriteVariables(avariables, false);
    }

    private void setValuesToWrite(ComVariable[] variables, String[] variablesValue) {
        for (int i = 0; i < variables.length; ++i) {
            variables[i].setValueToWrite(variablesValue[i]);
        }
    }

    @Deprecated
    public String[] setFormattedValues(int[] variablesId, String[] variablesValue) {
        String[] rst = new String[variablesId.length];
        for (int i = 0; i < variablesId.length; ++i) {
            String dato;
            int Q;
            int K;
            String maschera;
            ComVariable variabile;
            if (variablesId[i] < 0 || !(variabile = this.variables.get(variablesId[i])).isValidRecord()) continue;
            int posizioneK = variabile.getMask().indexOf("K");
            int posizioneQ = variabile.getMask().indexOf("Q");
            if (posizioneK > 0) {
                maschera = variabile.getMask().substring(0, posizioneK);
                if (posizioneQ > 0) {
                    K = Integer.parseInt(variabile.getMask().substring(posizioneK + 1, posizioneQ));
                    Q = Integer.parseInt(variabile.getMask().substring(posizioneQ + 1, variabile.getMask().length()));
                } else {
                    K = Integer.parseInt(variabile.getMask().substring(posizioneK + 1, variabile.getMask().length()));
                    Q = 0;
                }
            } else if (posizioneQ > 0) {
                maschera = variabile.getMask().substring(0, posizioneQ);
                K = 1;
                Q = Integer.parseInt(variabile.getMask().substring(posizioneQ + 1, variabile.getMask().length()));
            } else {
                maschera = variabile.getMask();
                K = 1;
                Q = 0;
            }
            try {
                dato = Double.toString(Double.parseDouble(variablesValue[i]) * (double)K + (double)Q);
            }
            catch (NumberFormatException e) {
                dato = variabile.getValueRead();
            }
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator('\'');
            decimalFormatSymbols.setDecimalSeparator('.');
            DecimalFormat formatter = new DecimalFormat(maschera);
            formatter.setDecimalFormatSymbols(decimalFormatSymbols);
            if (variabile.getType().toUpperCase().equals("INT") || variabile.getType().toUpperCase().equals("DINT")) {
                try {
                    dato = Integer.toString((int)Double.parseDouble(dato));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int posizioneVirgola = maschera.lastIndexOf(".");
                if (posizioneVirgola > 0) {
                    posizioneVirgola = maschera.length() - posizioneVirgola - 1;
                }
                if (posizioneVirgola < 0) {
                    posizioneVirgola = 0;
                }
                try {
                    rst[i] = Integer.toString((int)((double)Integer.parseInt(dato) * Math.pow(10.0, posizioneVirgola)));
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                rst[i] = formatter.format(Double.parseDouble(dato));
                continue;
            }
            catch (Exception e) {
                rst[i] = dato;
            }
        }
        return rst;
    }
}

