/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.fileutils;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.hivetechnology.fileutils.CustomFileFilter;

public class FileUtils {
    public static String readIniKey(String fileName, String key, String defaultValue) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(fileName));
        String value = p.getProperty(key);
        if (value == null) {
            System.out.println("Error " + new FileUtils().getClass().getCanonicalName() + ".readIniKey --> Key \"" + key + "\" not found");
            value = defaultValue;
        }
        String rst = value;
        return rst;
    }

    public static List<String> readIni(String fileName) throws Exception {
        File file = new File(fileName);
        fileName = file.getCanonicalPath();
        Path filePath = new File(fileName).toPath();
        Charset charset = Charset.forName("UTF-8");
        List<String> rst = Files.readAllLines(filePath, charset);
        return rst;
    }

    public static String[] readDes(String fileName, int length, boolean showErrorDialog) {
        String[] rst;
        block3: {
            try {
                rst = new String[length];
                Path filePath = new File(fileName).toPath();
                Charset charset = Charset.forName("UTF-8");
                List<String> lines = Files.readAllLines(filePath, charset);
                for (int i = 0; i < Math.min(lines.size(), rst.length); ++i) {
                    rst[i] = lines.get(i);
                }
            }
            catch (IOException e) {
                rst = null;
                System.out.println("Error " + new FileUtils().getClass().getCanonicalName() + ".readDes --> " + e);
                if (!showErrorDialog) break block3;
                JOptionPane.showMessageDialog(null, "Could not open file: " + fileName, "Error opening file", 0);
            }
        }
        return rst;
    }

    public static boolean writeIniKey(String fileName, String key, String value) {
        boolean rst;
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(fileName));
            p.setProperty(key, value);
            try (FileOutputStream out = new FileOutputStream(fileName);){
                p.store(out, "File updated");
            }
            rst = true;
        }
        catch (FileNotFoundException e) {
            p.setProperty(key, value);
            try {
                try (FileOutputStream out = new FileOutputStream(fileName);){
                    p.store(out, "File updated");
                }
                rst = true;
            }
            catch (Exception e2) {
                System.out.println(e2);
                rst = false;
            }
        }
        catch (Exception e) {
            System.out.println("Error " + new FileUtils().getClass().getCanonicalName() + ".writeIniKey --> " + e);
            rst = false;
        }
        return rst;
    }

    public static File searchFile(Component parent, File directory, String title, int fileType) throws Exception {
        JFileChooser fc = new JFileChooser();
        if (!title.equals("")) {
            fc.setDialogTitle(title);
        }
        if (directory != null) {
            fc.setCurrentDirectory(directory);
        }
        fc.setFileSelectionMode(fileType);
        int returnVal = fc.showOpenDialog(parent);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            return file;
        }
        throw new Exception("No correct file selected");
    }

    public static File searchFile(Component parent, String title, int fileType) throws Exception {
        return FileUtils.searchFile(parent, null, title, fileType);
    }

    public static File searchFile(Component parent, File directory, String title) throws Exception {
        return FileUtils.searchFile(parent, directory, title, 2);
    }

    public static File searchFile(Component parent, String title) throws Exception {
        return FileUtils.searchFile(parent, null, title, 2);
    }

    public static File searchFile(Component parent, File directory) throws Exception {
        return FileUtils.searchFile(parent, directory, "", 2);
    }

    public static String openFile(String sTitle, String sRoot, String sDescription, String sFilter) {
        String sReturn = "";
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(sTitle);
        if (!sFilter.equals("")) {
            CustomFileFilter apFilter = new CustomFileFilter(sDescription, sFilter);
            fc.addChoosableFileFilter(apFilter);
            fc.setAcceptAllFileFilterUsed(false);
        }
        fc.setCurrentDirectory(new File(sRoot));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            sReturn = fc.getSelectedFile().getAbsolutePath();
        }
        return sReturn;
    }

    public static String saveFile(String sTitle, String sRoot, String sDescription, String sFilter) {
        String sReturn = "";
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(sTitle);
        if (!sFilter.equals("")) {
            CustomFileFilter apFilter = new CustomFileFilter(sDescription, sFilter);
            fc.addChoosableFileFilter(apFilter);
            fc.setAcceptAllFileFilterUsed(false);
        }
        fc.setCurrentDirectory(new File(sRoot));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            sReturn = fc.getSelectedFile().getAbsolutePath();
        }
        return sReturn;
    }

    public static String getUserWorkingDirectory() {
        String OS = System.getProperty("os.name").toUpperCase();
        String userWorkingDirectory = OS.contains("WIN") ? System.getenv("AppData") : System.getProperty("user.home");
        return userWorkingDirectory;
    }

    public static boolean lockInstance(final String lockFile) {
        boolean rst = false;
        try {
            final File file = new File(lockFile);
            final RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            final FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            fileLock.release();
                            randomAccessFile.close();
                            file.delete();
                        }
                        catch (Exception e) {
                            System.out.println("Unable to remove lock file: " + lockFile + " --> " + e);
                        }
                    }
                });
                rst = true;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to create and/or lock file: " + lockFile + " --> " + e);
        }
        System.out.println("App already running see lock file: " + lockFile);
        return rst;
    }

    public static String sanitizeFileName(String fileName) {
        String rst = fileName.trim();
        rst = rst.replace("\\", "_");
        rst = rst.replace("/", "_");
        rst = rst.replace(":", "_");
        rst = rst.replace("*", "_");
        rst = rst.replace("?", "_");
        rst = rst.replace("\"", "_");
        rst = rst.replace("<", "_");
        rst = rst.replace(">", "_");
        rst = rst.replace("|", "_");
        rst = rst.replace(",", "_");
        return rst;
    }
}

