/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.o17036;

import java.io.File;
import java.util.ArrayList;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.o17036.Application;

public class PresetConfigurations {
    private final String className = this.getClass().getCanonicalName();
    private final String classSimpleName = this.getClass().getSimpleName();
    public static final String N1TCT101 = "n1 TCT101";
    public static final String N1TCT101MEMO = "n1 TCT101_memo";
    public static final String N1TCT101N1STR560 = "n1 TCT101 & n1 STR561";
    public static final String N1TCT101MEMON1STR560 = "n1 TCT101_memo & n1 STR561";
    private String serialPort = "COM1";
    private String serialParameters = "19200,n,8,1";
    private String counterMask = "0";
    private String scaleMask = "0";
    public static String presetConfig = "n1 TCT101";
    private ArrayList<String> connections;
    private ArrayList<String> tags;

    public PresetConfigurations() {
        if (this.initData()) {
            this.setCommunicationsDrivers();
        }
    }

    public ArrayList<String> getConnections() {
        return this.connections;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    private boolean initData() {
        boolean rst = false;
        String setupFileName = "setup" + File.separatorChar + Application.AppData.getCODE() + ".ini";
        File setupFile = new File(setupFileName);
        try {
            setupFileName = setupFile.getCanonicalPath();
            this.serialPort = FileUtils.readIniKey(setupFileName, "serialPort", this.serialPort);
            this.serialParameters = FileUtils.readIniKey(setupFileName, "serialParameters", this.serialParameters);
            this.counterMask = FileUtils.readIniKey(setupFileName, "mask", this.counterMask);
            this.scaleMask = FileUtils.readIniKey(setupFileName, "scaleMask", this.scaleMask);
            presetConfig = FileUtils.readIniKey(setupFileName, "presetConfig", presetConfig);
            rst = true;
        }
        catch (Exception e) {
            System.out.println("Error " + this.className + ".initData --> " + e);
        }
        return rst;
    }

    private boolean setCommunicationsDrivers() {
        boolean rst = false;
        this.connections = new ArrayList();
        this.tags = new ArrayList();
        switch (presetConfig) {
            case "n1 TCT101_memo & n1 STR561": 
            case "n1 TCT101_memo": {
                this.tags.add("Counter1Hold1,Counter1,MD 608,DInt," + this.counterMask + ",,");
                this.tags.add("Counter1Input,Counter1,MW 101,Int,,,");
            }
            case "n1 TCT101 & n1 STR561": {
                if (!presetConfig.equals(N1TCT101MEMO)) {
                    this.connections.add("Scale1,3," + this.serialPort + "," + this.serialParameters.replace(" ", "").replace(",", "_") + ",2,");
                    this.tags.add("Scale1Value1,Scale1,MD 1000,DInt," + this.scaleMask + ",,");
                }
            }
            case "n1 TCT101": {
                this.connections.add("Counter1,3," + this.serialPort + "," + this.serialParameters.replace(" ", "").replace(",", "_") + ",1,");
                this.tags.add("Counter1Value1,Counter1,MD 600,DInt," + this.counterMask + ",,");
                this.tags.add("Counter1Command1,Counter1,MW 620,Int,,,");
                this.tags.add("Counter1Load1,Counter1,MW 2024,Int," + this.counterMask + ",,");
                rst = true;
                break;
            }
            default: {
                presetConfig = N1TCT101;
                this.setCommunicationsDrivers();
            }
        }
        return rst;
    }
}

