/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.o17036;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.o17036.Application;
import net.hivetechnology.o17036.GUImanager;
import net.hivetechnology.o17036.PresetConfigurations;
import net.hivetechnology.plc.comunication.Comunication;
import net.hivetechnology.testcode.TestCode;
import net.hivetechnology.testcode.TestCodeGUI;
import net.hivetechnology.variables.ComVariable;

public class O17036 {
    private final String className = this.getClass().getCanonicalName();
    private static boolean startVisible = false;
    private boolean firstScan = true;
    private int timerMasterInterval = 250;
    private int timerScheduling = 250;
    private String pathDataIn = "data/IN/";
    private String pathDataOut = "data/OUT/";
    private double ofsetMemo = 0.1;
    private Comunication communication;
    private int loadedVariables;
    private String lastReportFileName = "";

    public O17036() {
        System.out.println(Application.AppData.getCODE() + " V" + Application.AppData.getVERSION());
        if (this.initData()) {
            this.setCommunicationsDrivers();
            this.initVariables();
            this.initTimerMaster();
            new GUImanager(startVisible, this.communication).manageGUI();
        }
    }

    private boolean initData() {
        boolean rst = false;
        String setupFileName = "setup" + File.separatorChar + Application.AppData.getCODE() + ".ini";
        File setupFile = new File(setupFileName);
        try {
            setupFileName = setupFile.getCanonicalPath();
            if (Application.type == 0) {
                Application.AppData.language = FileUtils.readIniKey(setupFileName, "language", Application.AppData.language);
                startVisible = Boolean.parseBoolean(FileUtils.readIniKey(setupFileName, "startVisible", String.valueOf(startVisible)));
            }
            this.timerMasterInterval = Integer.parseInt(FileUtils.readIniKey(setupFileName, "timerMasterInterval", String.valueOf(this.timerMasterInterval)));
            this.timerScheduling = Integer.parseInt(FileUtils.readIniKey(setupFileName, "timerScheduling", String.valueOf(this.timerScheduling)));
            this.pathDataIn = FileUtils.readIniKey(setupFileName, "pathDataIn", this.pathDataIn);
            this.pathDataOut = FileUtils.readIniKey(setupFileName, "pathDataOut", this.pathDataOut);
            this.ofsetMemo = Double.parseDouble(FileUtils.readIniKey(setupFileName, "ofsetMemo", String.valueOf(this.ofsetMemo)));
            rst = true;
        }
        catch (Exception e) {
            System.out.println("Error " + this.getClass().getCanonicalName() + ".initData --> " + e);
        }
        return rst;
    }

    private boolean setCommunicationsDrivers() {
        boolean rst = true;
        PresetConfigurations preConf = new PresetConfigurations();
        String connectionsFile = "setup" + File.separatorChar + "connections.csv";
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(connectionsFile)));){
            preConf.getConnections().forEach(connection -> writer.println((String)connection));
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Error " + this.className + ".setCommunicationsDrivers --> " + e);
            rst = false;
        }
        String tagsFile = "setup" + File.separatorChar + "tags.csv";
        if (!new File(tagsFile).isFile()) {
            try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(tagsFile)));){
                preConf.getTags().forEach(tag -> writer.println((String)tag));
                writer.close();
            }
            catch (Exception e) {
                System.out.println("Error " + this.className + ".setCommunicationsDrivers --> " + e);
                rst = false;
            }
        }
        return rst;
    }

    private void initVariables() {
        this.communication = new Comunication("setup");
        this.communication.startScheduling(this.timerScheduling);
    }

    private void initTimerMaster() {
        final Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!Application.AppData.appEND()) {
                    O17036.this.timerMaster();
                } else {
                    timer.cancel();
                    O17036.this.communication.stopSchedulinig();
                    Application.AppData.setAppRUN(false);
                    System.out.println(O17036.this.className + ".timerMaster STOP");
                }
            }
        };
        timer.schedule(task, 0L, (long)this.timerMasterInterval);
    }

    private void timerMaster() {
        String[] variablesName;
        block49: {
            if (PresetConfigurations.presetConfig.equals("n1 TCT101_memo") || PresetConfigurations.presetConfig.equals("n1 TCT101_memo & n1 STR561")) {
                variablesName = new String[]{"Counter1Hold1", "Scale1Value1"};
                ComVariable[] variables = this.communication.getVariables(new String[]{"Counter1Input"});
                this.communication.readVariables(variables, Application.AppData.getAppEND());
                String[] input = this.communication.getFormattedValues(variables);
                try {
                    ComVariable cvar;
                    if ((Integer.parseInt(input[0]) & 4) <= 0) break block49;
                    String[] stringArray = new String[]{"Counter1Value1"};
                    variables = this.communication.getVariables(stringArray);
                    String[] inputVal = this.communication.getFormattedValues(variables);
                    if (Double.parseDouble(inputVal[0]) >= this.ofsetMemo && (cvar = this.communication.getVariable("Counter1Command1")) != null) {
                        ArrayList<ComVariable> commandV = new ArrayList<ComVariable>();
                        commandV.add(cvar);
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("3");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("3");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("1");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                    }
                }
                catch (Exception inputVal) {}
            } else {
                variablesName = new String[]{"Counter1Value1", "Scale1Value1"};
            }
        }
        String fileName = "";
        String command = "";
        String variable = "";
        String value = "";
        String sDir = this.pathDataIn;
        String sFile = sDir + File.separatorChar + "serialReportFileName.txt";
        if (new File(sFile).isFile()) {
            try (BufferedReader br = new BufferedReader(new FileReader(sFile));){
                String[] commands;
                String apString = br.readLine();
                if (apString != null && !(fileName = apString).contains(".txt")) {
                    fileName = fileName + ".txt";
                }
                if ((apString = br.readLine()) != null && (commands = apString.split(";")).length == 3) {
                    command = commands[0];
                    variable = commands[1];
                    value = commands[2];
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Error " + this.getClass().getCanonicalName() + ".timerMaster --> " + e);
            }
        }
        sDir = this.pathDataOut;
        sFile = sDir + File.separatorChar + fileName;
        if (!(fileName.equals("") || fileName.equals(this.lastReportFileName) || this.firstScan && new File(sFile).isFile())) {
            if (++Application.licenseCounter >= 20) {
                Application.licenseCounter = 0;
                O17036.checkLicense();
            }
            if (command.equalsIgnoreCase("set") && variable.equals("Counter1") && value.equals("0")) {
                switch (PresetConfigurations.presetConfig) {
                    case "n1 TCT101 & n1 STR561": 
                    case "n1 TCT101": 
                    case "n1 TCT101_memo & n1 STR561": 
                    case "n1 TCT101_memo": {
                        ComVariable cvar = this.communication.getVariable("Counter1Command1");
                        if (cvar == null) break;
                        ArrayList<ComVariable> commandV = new ArrayList<ComVariable>();
                        commandV.add(cvar);
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("1");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        cvar.setValue("0");
                        this.communication.WriteVariables(commandV, Application.AppData.getAppEND());
                        break;
                    }
                }
            }
            ComVariable[] variables = this.communication.getVariables(variablesName);
            this.communication.readVariables(variables, Application.AppData.getAppEND());
            String[] variablesValue = this.communication.getFormattedValues(variables);
            try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(sFile)));){
                for (String variableValue : variablesValue) {
                    writer.println(variableValue);
                }
                writer.close();
            }
            catch (Exception e) {
                System.out.println("Error " + this.getClass().getCanonicalName() + ".timerMaster --> " + e);
            }
        }
        this.lastReportFileName = fileName;
        this.firstScan = false;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Couldn't use system look and feel.");
        }
        if (FileUtils.lockInstance("Lock.txt")) {
            O17036.checkLicense();
            if (args.length > 0) {
                Application.type = 1;
                Application.AppData.language = args[0];
            }
            if (args.length > 1) {
                startVisible = Boolean.parseBoolean(args[1]);
            }
            O17036 o17036 = new O17036();
        }
    }

    public static boolean checkLicense() {
        TestCode testCode = new TestCode(Application.AppData.getCODE());
        boolean rst = testCode.getValue();
        if (!rst) {
            boolean end;
            TestCodeGUI testCodeGUI = new TestCodeGUI(testCode.getCodes());
            do {
                testCodeGUI.showGui();
                boolean apValore = testCode.getValue(testCodeGUI.getCodeInputed());
                if (apValore) {
                    end = apValore;
                    continue;
                }
                boolean bl = end = JOptionPane.showConfirmDialog(null, "License registration failed. Try again?", "HT Code", 0) != 0;
            } while (!end);
        }
        return rst;
    }
}

