/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.o17036;

import java.awt.EventQueue;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.o17036.Application;
import net.hivetechnology.o17036.GUI;
import net.hivetechnology.plc.comunication.Comunication;

public class GUImanager {
    private final boolean startVisible;
    private static boolean guiVisible = false;
    private final Comunication variables;
    private final String[] des = new String[60];

    public GUImanager(Comunication variables) {
        this(false, variables);
    }

    public GUImanager(boolean startVisible, Comunication variables) {
        this.startVisible = startVisible;
        this.variables = variables;
        this.initData();
    }

    private boolean initData() {
        this.initDes(Application.AppData.language, this.getClass().getSimpleName() + ".txt");
        boolean rst = true;
        return rst;
    }

    private void initDes(String language, String languageFile) {
        String desFile;
        String[] apDes;
        if (this.des[0] == null) {
            this.des[0] = "Do you really want to exit the application?";
            this.des[1] = "Attention";
            this.des[2] = "Show";
            this.des[3] = "About";
            this.des[4] = "Exit";
        }
        if (!language.equals("") && (apDes = FileUtils.readDes(desFile = "LNG" + File.separatorChar + language.toUpperCase() + File.separatorChar + languageFile, this.des.length, false)) != null) {
            System.arraycopy(apDes, 0, this.des, 0, apDes.length);
        }
    }

    public void manageGUI() {
        if (!guiVisible) {
            if (this.startVisible || !this.createAndShowTray()) {
                this.createAndShowGUI();
            }
        } else if (!this.createAndShowTray() && !this.closeApp()) {
            this.createAndShowGUI();
        }
    }

    private boolean createAndShowTray() {
        boolean rst = false;
        if (SystemTray.isSupported()) {
            final SystemTray systemTray = SystemTray.getSystemTray();
            ImageIcon icon = new ImageIcon(Application.AppData.getFAVICON_URL());
            final TrayIcon trayIcon = new TrayIcon(icon.getImage(), Application.AppData.getCODE() + " V" + Application.AppData.getVERSION());
            trayIcon.setImageAutoSize(true);
            final JPopupMenu popMenu = new JPopupMenu();
            JMenuItem show = new JMenuItem(this.des[2]);
            show.addActionListener(evt -> {
                this.createAndShowGUI();
                systemTray.remove(trayIcon);
            });
            popMenu.add(show);
            JMenuItem about = new JMenuItem(this.des[3]);
            ImageIcon logo = new ImageIcon(this.getClass().getResource("/net/hivetechnology/o17036/img/hive.png"));
            String message = "<html><b>O17036 HT DataBasic</b><br><br>Hive Technology<br><a href=\"www.hivetechnology.net\">www.hivetechnology.net</a><br><br>Via Dino Saccenti 13/25, 59100 Prato (PO) Italia&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br>C.F e P.Iva 02388370971<br><br>Copyright &copy; 2022 Hive Technology<br>V" + Application.AppData.getVERSION() + "</html>";
            String title = "About";
            about.addActionListener(evt -> JOptionPane.showMessageDialog(null, message, title, -1, logo));
            popMenu.add(about);
            popMenu.add(new JSeparator());
            JMenuItem exit = new JMenuItem(this.des[4]);
            exit.addActionListener(evt -> {
                if (this.closeApp()) {
                    systemTray.remove(trayIcon);
                }
            });
            popMenu.add(exit);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    switch (e.getButton()) {
                        case 1: {
                            if (e.getClickCount() != 2) break;
                            GUImanager.this.createAndShowGUI();
                            systemTray.remove(trayIcon);
                            break;
                        }
                        case 3: {
                            if (e.isPopupTrigger()) {
                                popMenu.setLocation(e.getXOnScreen(), e.getYOnScreen());
                                popMenu.setInvoker(popMenu);
                                popMenu.setVisible(true);
                                break;
                            }
                            popMenu.setInvoker(null);
                            popMenu.setVisible(false);
                        }
                    }
                }
            };
            trayIcon.addMouseListener(mouseAdapter);
            try {
                systemTray.add(trayIcon);
                guiVisible = false;
                rst = true;
            }
            catch (Exception e) {
                System.out.println("Error " + this.getClass().getCanonicalName() + ".createAndShowTray --> " + e);
            }
        }
        return rst;
    }

    private void createAndShowGUI() {
        EventQueue.invokeLater(() -> {
            new GUI(this.variables).setVisible(true);
            guiVisible = true;
        });
    }

    public boolean closeApp() {
        boolean rst = false;
        if (JOptionPane.showConfirmDialog(null, this.des[0], this.des[1], 0) == 0) {
            Application.AppData.setAppEND(true);
            rst = true;
        }
        return rst;
    }
}

