/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.o17036;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.o17036.Application;
import net.hivetechnology.o17036.GUImanager;
import net.hivetechnology.o17036.O17036;
import net.hivetechnology.plc.comunication.Comunication;
import net.hivetechnology.variables.ComVariable;

public class GUI
extends JFrame {
    private final String className = this.getClass().getCanonicalName();
    private final String[] des = new String[60];
    private int[] windowPosition = new int[]{200, 200};
    private int windowWidth = 360;
    private int windowHeight = 120;
    private boolean alwaysOnTop = true;
    private boolean undecorated = true;
    private Font fontPredefinito;
    private int timerMasterInterval = 250;
    private final Comunication communication;
    private boolean guiEND = false;
    private JTextField jtfCounter1Value1 = new JTextField();
    private JTextField jtfScale1Value1 = new JTextField();

    public GUI(Comunication variables) {
        this.communication = variables;
        this.initData();
        this.initTimerMaster();
        this.initForm();
    }

    private boolean initData() {
        boolean rst;
        String setupFileName = "setup" + File.separatorChar + Application.AppData.getCODE() + ".ini";
        File setupFile = new File(setupFileName);
        try {
            setupFileName = setupFile.getCanonicalPath();
            this.initDes(Application.AppData.language, this.getClass().getSimpleName() + ".txt");
            String[] apWindowPosition = FileUtils.readIniKey(setupFileName, "windowPosition", this.windowPosition[0] + "," + this.windowPosition[1]).split(",");
            this.windowPosition = new int[]{Integer.parseInt(apWindowPosition[0]), Integer.parseInt(apWindowPosition[1])};
            this.windowWidth = Integer.parseInt(FileUtils.readIniKey(setupFileName, "windowWidth", String.valueOf(this.windowWidth)));
            this.windowHeight = Integer.parseInt(FileUtils.readIniKey(setupFileName, "windowHeight", String.valueOf(this.windowHeight)));
            this.alwaysOnTop = Boolean.parseBoolean(FileUtils.readIniKey(setupFileName, "alwaysOnTop", String.valueOf(this.alwaysOnTop)));
            this.undecorated = Boolean.parseBoolean(FileUtils.readIniKey(setupFileName, "undecorated", String.valueOf(this.undecorated)));
            String[] apFont = FileUtils.readIniKey(setupFileName, "font", "Tahoma,0,16").split(",");
            this.fontPredefinito = new Font(apFont[0], Integer.parseInt(apFont[1]), Integer.parseInt(apFont[2]));
            this.timerMasterInterval = Integer.parseInt(FileUtils.readIniKey(setupFileName, "timerMasterInterval", String.valueOf(this.timerMasterInterval)));
            rst = true;
        }
        catch (Exception e) {
            rst = false;
            System.out.println("Error " + this.getClass().getCanonicalName() + ".initData --> " + e);
        }
        return rst;
    }

    private void initDes(String language, String languageFile) {
        String desFile;
        String[] apDes;
        if (this.des[0] == null) {
            this.des[0] = Application.AppData.getCODE();
            this.des[1] = "Directory: \"";
            this.des[2] = "\" not found";
            this.des[3] = "Counter value:";
            this.des[4] = "Exit";
            this.des[5] = "Scale value:";
        }
        if (!language.equals("") && (apDes = FileUtils.readDes(desFile = "LNG" + File.separatorChar + language.toUpperCase() + File.separatorChar + languageFile, this.des.length, false)) != null) {
            System.arraycopy(apDes, 0, this.des, 0, apDes.length);
        }
    }

    private void initTimerMaster() {
        final Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!Application.AppData.appEND() && !GUI.this.guiEND) {
                    GUI.this.timerMaster();
                } else {
                    timer.cancel();
                    GUI.this.dispose();
                    System.out.println(GUI.this.className + ".timerMaster STOP");
                }
            }
        };
        timer.schedule(task, 0L, (long)this.timerMasterInterval);
    }

    private void timerMaster() {
        String[] variablesName = new String[]{"Counter1Value1", "Scale1Value1"};
        if (Application.licenseCounter >= 20) {
            Application.licenseCounter = 0;
            O17036.checkLicense();
        }
        ComVariable[] variables = this.communication.getVariables(variablesName);
        this.communication.readVariables(variables, Application.AppData.getAppEND());
        ++Application.licenseCounter;
        String[] variablesValue = this.communication.getFormattedValues(variables);
        EventQueue.invokeLater(() -> {
            this.jtfCounter1Value1.setText(variablesValue[0]);
            this.jtfScale1Value1.setText(variablesValue[1]);
        });
    }

    private void initForm() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GUI.this.closeGUI();
            }
        });
        UIManager.put("Label.font", this.fontPredefinito);
        UIManager.put("Button.font", this.fontPredefinito);
        UIManager.put("TextField.font", this.fontPredefinito);
        JPanel jpInner = new JPanel();
        JLabel jlCounter1Value1 = new JLabel();
        JLabel jlScale1Value1 = new JLabel();
        this.jtfCounter1Value1 = new JTextField();
        this.jtfScale1Value1 = new JTextField();
        JButton jbExit = new JButton();
        JLabel jlVersion = new JLabel();
        jpInner.setLayout(new GridBagLayout());
        jlCounter1Value1.setText(this.des[3]);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        jpInner.add((Component)jlCounter1Value1, gridBagConstraints);
        this.jtfCounter1Value1.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 16, 0, 8);
        jpInner.add((Component)this.jtfCounter1Value1, gridBagConstraints);
        jlScale1Value1.setText(this.des[5]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        jpInner.add((Component)jlScale1Value1, gridBagConstraints);
        this.jtfScale1Value1.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 16, 0, 8);
        jpInner.add((Component)this.jtfScale1Value1, gridBagConstraints);
        jlVersion.setText(Application.AppData.getCODE() + " V" + Application.AppData.getVERSION());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        jpInner.add((Component)jlVersion, gridBagConstraints);
        jbExit.setText(this.des[4]);
        jbExit.setName("exit");
        jbExit.addActionListener(evt -> this.jbMouseClicked(evt));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, 16, 0, 8);
        jpInner.add((Component)jbExit, gridBagConstraints);
        this.getContentPane().add((Component)jpInner, "Center");
        this.setTitle(this.des[0] + " (www.hivetechnology.net)");
        this.setIconImage(Application.AppData.getFAVICON_IMG());
        this.setAlwaysOnTop(this.alwaysOnTop);
        this.setLocation(this.windowPosition[0], this.windowPosition[1]);
        this.setResizable(false);
        this.setPreferredSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setUndecorated(this.undecorated);
        this.pack();
    }

    private void jbMouseClicked(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        String apString = button.getName();
        if (apString.equals("exit")) {
            this.closeGUI();
        }
    }

    private void closeGUI() {
        this.guiEND = true;
        new GUImanager(this.communication).manageGUI();
    }
}

