/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.testcode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.hivetechnology.keyboard.DialogKeyBoard;
import net.hivetechnology.testcode.Application;
import net.hivetechnology.testcode.Code;
import net.hivetechnology.testcode.ComboItem;

public class TestCodeGUI
extends JDialog {
    private final Code code;
    private Map<String, Code> codes;
    private final boolean showKeyboard;
    private final JTextField[] jtHDcode = new JTextField[4];
    private final JLabel[] jlHDcode = new JLabel[4];
    private Code codeInputed = new Code("ERRORERROERROERRO");
    private final boolean showMacsChooser;

    public TestCodeGUI(Code code) {
        this(code, false);
    }

    public TestCodeGUI(Code code, JFrame jframe) {
        this(code, false, jframe);
    }

    public TestCodeGUI(Code code, boolean showKeyboard) {
        this(code, showKeyboard, null);
    }

    public TestCodeGUI(Code code, boolean showKeyboard, JFrame jframe) {
        super(jframe);
        this.code = code;
        this.showKeyboard = showKeyboard;
        this.showMacsChooser = false;
    }

    public TestCodeGUI(Map<String, Code> codes) {
        this(codes, false);
    }

    public TestCodeGUI(Map<String, Code> codes, JFrame jframe) {
        this(codes, false, jframe);
    }

    public TestCodeGUI(Map<String, Code> codes, boolean showKeyboard) {
        this(codes, showKeyboard, null);
    }

    public TestCodeGUI(Map<String, Code> codes, boolean showKeyboard, JFrame jframe) {
        super(jframe);
        this.codes = codes;
        this.code = this.codes.values().stream().findFirst().get();
        this.showKeyboard = showKeyboard;
        this.showMacsChooser = true;
    }

    public void showGui() {
        this.initForm();
    }

    public Code getCodeInputed() {
        return this.codeInputed;
    }

    private void jButtonClicked(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        String apString = button.getText();
        if (!apString.equals("ESC") && apString.equals("OK")) {
            String sFullCode = "";
            for (int i = 0; i < 4; ++i) {
                sFullCode = sFullCode + this.jtHDcode[i].getText();
            }
            this.codeInputed = new Code(sFullCode);
        }
        this.endForm();
    }

    private void jtHDcodeClicked(MouseEvent evt) {
        JTextField textfiled = (JTextField)evt.getSource();
        DialogKeyBoard dlgKey = new DialogKeyBoard((Dialog)this, textfiled.getText(), true, true, false);
        dlgKey.setVisible(true);
        String apValore = dlgKey.getValue();
        textfiled.setText(apValore);
    }

    private void endForm() {
        this.dispose();
    }

    private void initForm() {
        GridBagConstraints c;
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        JPanel jptastnum = new JPanel(new GridLayout(2, 1));
        JButton[] jbtastnum = new JButton[2];
        int i = 0;
        jbtastnum[i] = new JButton("ESC");
        jbtastnum[i].setBackground(new Color(192, 192, 255));
        i = 1;
        jbtastnum[i] = new JButton("OK");
        jbtastnum[i].setBackground(new Color(255, 192, 192));
        for (i = 0; i < 2; ++i) {
            jbtastnum[i].addActionListener(evt -> this.jButtonClicked(evt));
            jbtastnum[i].setPreferredSize(new Dimension(60, 60));
            jbtastnum[i].setFont(new Font("Tahoma", 0, 16));
            jptastnum.add(jbtastnum[i]);
        }
        JPanel jpLabel = new JPanel(new GridLayout(2, 4));
        for (i = 0; i < 4; ++i) {
            this.jlHDcode[i] = new JLabel();
            this.jlHDcode[i].setBackground(new Color(255, 192, 192));
            this.jlHDcode[i].setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
            this.jlHDcode[i].setOpaque(true);
            this.jlHDcode[i].setPreferredSize(new Dimension(150, 10));
            this.jlHDcode[i].setFont(new Font("Tahoma", 0, 25));
            this.jlHDcode[i].setHorizontalAlignment(0);
            jpLabel.add(this.jlHDcode[i]);
        }
        this.initCode(this.code);
        for (i = 0; i < 4; ++i) {
            final int numeroMassimoDiCaratteri = i == 0 ? 5 : 4;
            this.jtHDcode[i] = new JTextField(){

                @Override
                public void setText(String str) {
                    if (str.length() >= numeroMassimoDiCaratteri) {
                        str = str.substring(0, numeroMassimoDiCaratteri);
                    }
                    super.setText(str);
                }
            };
            this.jtHDcode[i].setBackground(new Color(255, 255, 255));
            this.jtHDcode[i].setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
            this.jtHDcode[i].setOpaque(true);
            this.jtHDcode[i].setPreferredSize(new Dimension(150, 10));
            this.jtHDcode[i].setFont(new Font("Tahoma", 0, 25));
            this.jtHDcode[i].setHorizontalAlignment(0);
            if (this.showKeyboard) {
                this.jtHDcode[i].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        TestCodeGUI.this.jtHDcodeClicked(evt);
                    }
                });
            }
            this.jtHDcode[i].setDocument(new PlainDocument(){

                @Override
                public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                    if (this.getLength() >= numeroMassimoDiCaratteri) {
                        return;
                    }
                    super.insertString(offset, str, a);
                }
            });
            jpLabel.add(this.jtHDcode[i]);
        }
        if (this.showMacsChooser) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            ArrayList<ComboItem> model = new ArrayList<ComboItem>();
            for (Map.Entry<String, Code> entry : this.codes.entrySet()) {
                model.add(new ComboItem(entry.getValue(), entry.getKey()));
            }
            JComboBox<Object> jcbMacs = new JComboBox<Object>(model.toArray());
            jcbMacs.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ComboItem item = (ComboItem)e.getItem();
                    Code code = item.getValue();
                    this.initCode(code);
                }
            });
            box.add(jcbMacs, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        c.weightx = 0.0;
        jpLabel.setAlignmentX(1.0f);
        box.add((Component)jpLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        c.weightx = 1.0;
        jptastnum.setAlignmentX(1.0f);
        box.add((Component)jptastnum, c);
        this.setContentPane(box);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TestCodeGUI.this.endForm();
            }
        });
        this.setTitle(Application.NAME + " V" + Application.VERSION);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/lock.png")).getImage());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initCode(Code code) {
        String[] sHWcode = code.split();
        for (int i = 0; i < 4; ++i) {
            this.jlHDcode[i].setText(sHWcode[i]);
        }
    }
}

