/*
 * Decompiled with CFR 0.152.
 */
package net.hivetechnology.testcode;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hivetechnology.fileutils.FileUtils;
import net.hivetechnology.testcode.Code;

public class TestCode {
    private final Map<String, String> macs;
    private final Map<String, Code> codes;
    private final String appCode;

    public TestCode(String appCode) {
        this.appCode = appCode;
        this.macs = this.getAllMacs();
        this.codes = this.getCodesFromMacs();
    }

    public boolean getValue() {
        Code code = this.getCodeCheckFromIni();
        return this.codes.values().stream().anyMatch(o -> o.createCodeCheck("18538").isValidAndEquals(code));
    }

    public boolean getValue(Code code) {
        boolean rst = false;
        if (this.codes.values().stream().anyMatch(o -> o.createCodeCheck("18538").isValidAndEquals(code))) {
            this.saveCodeCheckIni(code);
            rst = this.getValue();
        }
        return rst;
    }

    public Code getFirstValidCode() {
        return this.codes.values().stream().filter(o -> o.isValid()).findFirst().get();
    }

    private Map<String, String> getAllMacs() {
        HashMap<String, String> rst = new HashMap<String, String>();
        try {
            ArrayList<String> cmdMacs = this.getMacsFromCommandLine();
            for (int i = 0; i < cmdMacs.size(); ++i) {
                String code = cmdMacs.get(i);
                rst.put(code, "Generic " + i);
            }
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                byte[] mac = ni.getHardwareAddress();
                String code = "";
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    code = code + String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : "");
                }
                rst.put(code, ni.getDisplayName());
            }
        }
        catch (Exception e) {
            System.out.println("Error " + this.getClass().getCanonicalName() + ".getAllMacs --> " + e);
        }
        rst.remove("00-00-00-00-00-00");
        return rst;
    }

    private ArrayList<String> getMacsFromCommandLine() {
        ArrayList<String> rst = new ArrayList<String>();
        String command = "/sbin/ifconfig";
        String sOsName = System.getProperty("os.name");
        if (sOsName.startsWith("Windows")) {
            command = "ipconfig /all";
        } else if (sOsName.startsWith("Linux") || sOsName.startsWith("Mac") || sOsName.startsWith("HP-UX")) {
            command = "/sbin/ip a";
        } else {
            System.out.println("The current operating system '" + sOsName + "' is not supported.");
        }
        Pattern p = Pattern.compile("([a-fA-F0-9]{1,2}(-|:)){5}[a-fA-F0-9]{1,2}");
        try {
            String line;
            Process pa = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(pa.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.find()) continue;
                String code = m.group().replace(":", "-").toUpperCase();
                rst.add(code);
            }
        }
        catch (Exception e) {
            System.out.println("Error " + this.getClass().getCanonicalName() + ".getMACthroughCmd --> " + e);
        }
        return rst;
    }

    private Code getCodeCheckFromIni() {
        String iniFile = FileUtils.getUserWorkingDirectory();
        iniFile = iniFile + File.separatorChar + "HiveTechnology" + File.separatorChar + "HTactivationKey.ini";
        String sFullCode = "ERRORERROERROERRO";
        try {
            sFullCode = FileUtils.readIniKey((String)iniFile, (String)this.appCode, (String)sFullCode);
        }
        catch (Exception e) {
            System.out.println("Error " + this.getClass().getCanonicalName() + ".getCodeCheckFromIni --> " + e);
        }
        return new Code(sFullCode);
    }

    private void saveCodeCheckIni(Code code) {
        String iniFile = FileUtils.getUserWorkingDirectory();
        File dirHT = new File(iniFile = iniFile + File.separatorChar + "HiveTechnology");
        if (!dirHT.isDirectory()) {
            dirHT.mkdir();
        }
        iniFile = iniFile + File.separatorChar + "HTactivationKey.ini";
        try {
            FileUtils.writeIniKey((String)iniFile, (String)this.appCode, (String)code.toString());
        }
        catch (Exception e) {
            System.out.println("Error " + this.getClass().getCanonicalName() + ".saveCodeCheckIni --> " + e);
        }
    }

    public Map<String, String> getMacs() {
        return this.macs;
    }

    public Map<String, Code> getCodes() {
        return this.codes;
    }

    private Map<String, Code> getCodesFromMacs() {
        HashMap<String, Code> rst = new HashMap<String, Code>();
        for (Map.Entry<String, String> entry : this.macs.entrySet()) {
            Code code = new Code(this.appCode.substring(this.appCode.length() - 5) + entry.getKey());
            rst.put(entry.getValue() + " (" + entry.getKey() + ")", code);
        }
        return rst;
    }
}

